/*!
  * Sa11y, the accessibility quality assurance assistant.
  * @version 3.2.2
  * @author Adam Chaboryk
  * @license GPL-2.0-or-later
  * @copyright © 2020 - 2024 Toronto Metropolitan University.
  * @contact adam.chaboryk@torontomu.ca
  * GitHub: git+https://github.com/ryersondmp/sa11y.git | Website: https://sa11y.netlify.app
  * For all acknowledgements, please visit: https://sa11y.netlify.app/acknowledgements/
  * The above copyright notice shall be included in all copies or substantial portions of the Software.
**/
const e={checkRoot:"body",containerIgnore:".sa11y-ignore",contrastIgnore:'.sr-only, [role="menu"] *',outlineIgnore:"",headerIgnore:"",headerIgnoreSpan:"",headerIgnoreStrings:"",imageIgnore:"",linkIgnore:'nav *, [role="navigation"] *',linkIgnoreSpan:"",linkIgnoreStrings:"",aboutContent:"",delayCheck:0,delayCustomCheck:500,showGoodLinkButton:!0,showHinPageOutline:!1,showTitleInPageOutline:!0,showImageOutline:!0,editImageURLofCMS:"",relativePathImageSRC:"",relativePathImageID:"",detectSPArouting:!1,doNotRun:"",dismissAnnotations:!0,headless:!1,selectorPath:!1,shadowComponents:"",autoDetectShadowComponents:!1,panelPosition:"right",altTextMaxCharLength:250,susAltStopWords:"",linkStopWords:"",extraPlaceholderStopWords:"",headingMaxCharLength:170,URLTextMaxCharLength:40,URLAsLinkTextWarning:!0,readabilityPlugin:!0,readabilityRoot:"body",readabilityIgnore:"",contrastPlugin:!0,formLabelsPlugin:!0,linksAdvancedPlugin:!0,colourFilterPlugin:!0,customChecks:!1,checkAllHideToggles:!1,exportResultsPlugin:!1,linksToFlag:"",linksToDOI:!0,missingH1:!0,flagLongHeadings:!0,nonConsecutiveHeadingIsError:!0,badLinksQA:!0,strongItalicsQA:!0,pdfQA:!0,documentQA:!0,documentLinks:'a[href$=".doc"], a[href$=".docx"], a[href*=".doc?"], a[href*=".docx?"], a[href$=".ppt"], a[href$=".pptx"], a[href*=".ppt?"], a[href*=".pptx?"], a[href^="https://docs.google"], a[href^="https://sway."]',langQA:!0,blockquotesQA:!0,allCapsQA:!0,fakeHeadingsQA:!0,fakeListQA:!0,duplicateIdQA:!0,underlinedTextQA:!0,pageTitleQA:!0,subscriptQA:!0,inPageLinkQA:!0,tablesQA:!0,tablesQAmissingTH:!0,tablesQAsemanticHeadings:!0,tablesQAemptyTH:!0,tablesQAemptyTHisError:!0,embeddedContentAll:!0,embeddedContentAudio:!0,embeddedContentVideo:!0,embeddedContentDataViz:!0,embeddedContentTitles:!0,embeddedContentGeneral:!0,videoContent:"youtube.com, vimeo.com, yuja.com, panopto.com",audioContent:"soundcloud.com, simplecast.com, podbean.com, buzzsprout.com, blubrry.com, transistor.fm, fusebox.fm, libsyn.com",dataVizContent:"datastudio, tableau, lookerstudio, powerbi, qlik"},t={langStrings:{},addI18n(e){this.langStrings=e},_(e){return this.translate(e)},sprintf(e,...t){let n=this._(e);return n=this.prepHTML(n),t&&t.length&&t.forEach((e=>{n=n.replace(/%\([a-zA-z]+\)/,e)})),n},translate(e){return this.langStrings[e]||e},prepHTML:e=>e.replaceAll(/<hr>/g,'<hr aria-hidden="true">').replaceAll(/<a[\s]href=/g,'<a target="_blank" rel="noopener noreferrer" href=').replaceAll(/<\/a>/g,`<span class="visually-hidden"> (${t._("NEW_TAB")})</span></a>`).replaceAll(/{R}/g,'class="red-text"').replaceAll(/{W}/g,'class="yellow-text"').replaceAll(/{B}/g,'class="badge"').replaceAll(/{ALT}/g,`<strong class="badge">${t._("ALT")}</strong>`).replaceAll(/{L}/g,`<strong class="badge"><span class="link-icon"></span><span class="visually-hidden">${t._("LINKED")}</span></strong>`)},n=function(){const e={};const o={};const i={};const a={};const r={};const s={};return{initializeRoot:function(t,n){e.areaToCheck=document.querySelector(t),e.areaToCheck||(e.areaToCheck=document.querySelector("body")),e.Readability=document.querySelector(n),e.Readability||(e.areaToCheck?(e.Readability=e.areaToCheck,console.error(`Sa11y configuration error: The selector '${n}' used for the property 'readabilityRoot' does not exist. '${e.areaToCheck.tagName}' was used as a fallback.`)):e.Readability=document.querySelector("body"))},Root:e,initializeGlobal:function(e){o.html=document.querySelector("html"),o.headless=e.headless,o.panelPosition=e.panelPosition,o.dismissAnnotations=e.dismissAnnotations,o.aboutContent=e.aboutContent,o.contrastPlugin=e.contrastPlugin,o.formLabelsPlugin=e.formLabelsPlugin,o.linksAdvancedPlugin=e.linksAdvancedPlugin,o.colourFilterPlugin=e.colourFilterPlugin,o.checkAllHideToggles=e.checkAllHideToggles,o.exportResultsPlugin=e.exportResultsPlugin,o.showImageOutline=e.showImageOutline,o.editImageURLofCMS=e.editImageURLofCMS,o.relativePathImageSRC=e.relativePathImageSRC,o.relativePathImageID=e.relativePathImageID;let t=!1;"function"==typeof window.matchMedia&&(t=window.matchMedia("(prefers-reduced-motion: reduce)")),o.scrollBehaviour=!t||t.matches?"auto":"smooth",o.langDirection="rtl"===o.html.getAttribute("dir")?"rtl":"ltr",e.documentLinks&&(o.documentLinks=`${e.documentLinks}`)},Global:o,initializePanelSelectors:function(){const e=document.querySelector("sa11y-control-panel").shadowRoot;i.panel=e.getElementById("panel"),i.content=e.getElementById("panel-content"),i.controls=e.getElementById("panel-controls"),i.outline=e.getElementById("outline-panel"),i.outlineContent=e.getElementById("outline-content"),i.outlineList=e.getElementById("outline-list"),i.outlineHeader=e.getElementById("outline-header"),i.images=e.getElementById("images-panel"),i.imagesContent=e.getElementById("images-content"),i.imagesList=e.getElementById("images-list"),i.imagesHeader=e.getElementById("images-header"),i.notifBadge=e.getElementById("notification-badge"),i.notifCount=e.getElementById("notification-count"),i.notifText=e.getElementById("notification-text"),i.status=e.getElementById("status"),i.pageIssues=e.getElementById("page-issues"),i.pageIssuesList=e.getElementById("page-issues-list"),i.pageIssuesHeader=e.getElementById("page-issues-header"),i.pageIssuesContent=e.getElementById("page-issues-content"),i.settings=e.getElementById("settings-panel"),i.settingsHeader=e.getElementById("settings-header"),i.settingsContent=e.getElementById("settings-content"),i.contrastToggle=e.getElementById("contrast-toggle"),i.labelsToggle=e.getElementById("labels-toggle"),i.linksToggle=e.getElementById("links-advanced-toggle"),i.readabilityToggle=e.getElementById("readability-toggle"),i.themeToggle=e.getElementById("theme-toggle"),i.contrastItem=e.getElementById("contrast-item"),i.labelsItem=e.getElementById("form-labels-item"),i.linksItem=e.getElementById("links-advanced-item"),i.readabilityItem=e.getElementById("readability-item"),i.darkModeItem=e.getElementById("dark-mode-item"),i.colourPanel=e.getElementById("panel-colour-filters"),i.colourFilterItem=e.getElementById("colour-filter-item"),i.colourFilterSelect=e.getElementById("colour-filter-select"),i.colourFilterIcon=e.getElementById("filter-icon"),i.toggle=e.getElementById("toggle"),i.outlineToggle=e.getElementById("outline-toggle"),i.imagesToggle=e.getElementById("images-toggle"),i.settingsToggle=e.getElementById("settings-toggle"),i.skipButton=e.getElementById("skip-button"),i.dismissButton=e.getElementById("dismiss-button"),i.dismissTooltip=e.getElementById("dismiss-tooltip"),i.skipToPageIssues=e.getElementById("skip-to-page-issues"),i.exportHTML=e.getElementById("export-html"),i.exportCSV=e.getElementById("export-csv"),i.alert=e.getElementById("panel-alert"),i.alertText=e.getElementById("panel-alert-text"),i.alertPreview=e.getElementById("panel-alert-preview"),i.alertClose=e.getElementById("close-alert"),i.readability=e.getElementById("readability-panel"),i.readabilityInfo=e.getElementById("readability-info"),i.readabilityDetails=e.getElementById("readability-details")},Panel:i,initializeReadability:function(e){if(e.readabilityPlugin){a.Lang=t._("LANG_CODE").substring(0,2);const e=["en","fr","es","de","nl","it","sv","fi","da","no","nb","nn","pt"],o=n.Global.html.getAttribute("lang");if(o){const t=o.toLowerCase().substring(0,2);e.includes(t)&&e.includes(a.Lang)?a.Plugin=!0:a.Plugin=!1}else a.Plugin=!1}},Readability:a,initializeExclusions:function(e){if(e.containerIgnore){const t=e.containerIgnore.split(",").map((e=>`${e} *, ${e}`));r.Container=`#wpadminbar *, #sa11y-colour-filters, #sa11y-colour-filters *, ${t.join(", ")}`}else r.Container="#wpadminbar *, #sa11y-colour-filters, #sa11y-colour-filters *";r.Contrast="script, style, link",e.contrastIgnore&&(r.Contrast=`${e.contrastIgnore}, ${r.Contrast}`),r.Readability='nav li, [role="navigation"] li',e.readabilityIgnore&&(r.Readability=`${e.readabilityIgnore}, ${r.Readability}`),e.headerIgnore&&(r.Headings=`${e.headerIgnore}`),e.outlineIgnore&&(r.Outline=`${e.outlineIgnore}`),r.Images='[role="presentation"]',e.imageIgnore&&(r.Images=`${e.imageIgnore}, ${r.Images}`),r.Links=".anchorjs-link",e.linkIgnore&&(r.Links=`${e.linkIgnore}, ${r.Links}`),e.linkIgnoreSpan&&(r.LinkSpan=e.linkIgnoreSpan)},Exclusions:r,initializeEmbeddedContent:function(e){if(e.videoContent){const t=e.videoContent.split(/\s*[\s,]\s*/).map((e=>`[src*='${e}']`));s.Video=`video, ${t.join(", ")}`}else s.Video="video";if(e.audioContent){const t=e.audioContent.split(/\s*[\s,]\s*/).map((e=>`[src*='${e}']`));s.Audio=`audio, ${t.join(", ")}`}else s.Audio="audio";if(e.dataVizContent){const t=e.dataVizContent.split(/\s*[\s,]\s*/).map((e=>`[src*='${e}']`));s.Visualization=t.join(", ")}else s.Visualization="datastudio.google.com, tableau";s.All=`${s.Video}, ${s.Audio}, ${s.Visualization}`},EmbeddedContent:s}}();function o(e,t,o){let i;"document"===t?i=document:"readability"===t?(i=n.Readability.Root,i||(i=n.Root.areaToCheck)):"root"===t?(i=n.Root.areaToCheck,i||(i=document.body)):"panel"===t?(i=n.Panel.panel,i||(i=document.body)):(i=document.querySelector(t),i||(i=document.body));const a=document.querySelectorAll("[data-sa11y-has-shadow-root]"),r=a?", [data-sa11y-has-shadow-root]":"",s=n.Exclusions.Container,l=void 0!==o?`, ${o}`:"",d=Array.from(i.querySelectorAll(`:is(${e}${r}):not(${s}${l})`));if(a.length){const t=[];if(d.forEach(((n,o)=>{n&&n.matches&&n.matches("[data-sa11y-has-shadow-root]")&&n.shadowRoot&&(t[o]=n.shadowRoot.querySelectorAll(`:is(${e}):not(${s}${l})`))})),t.length>0)for(let e=t.length-1;e>=0;e--)t[e]&&d.splice(e,1,...t[e])}return d}function i(e){if(e.getAttribute("hidden"))return!0;return"none"===getComputedStyle(e).getPropertyValue("display")}function a(e){const t=document.createElement("div");return t.textContent=e,t.innerHTML.replaceAll('"',"&quot;").replaceAll("'","&#039;").replaceAll("`","&#x60;")}function r(e){return e.replace(/[^\w. ]/gi,(e=>`&#${e.charCodeAt(0)};`))}function s(e){return e.textContent.replace(/[\r\n]+/g,"").replace(/\s+/g," ").trim()}function l(e){return e.replace(/[\r\n]+/g," ").replace(/\s+/g," ").trim()}function d(e,t){const n="noscript, script, style",o=t?`${n}, ${t}`:n,i=e.cloneNode(!0);return Array.from(i.querySelectorAll(o)).forEach((e=>{e.parentElement.removeChild(e)})),i}function c(e,t,n){let o=e;for(;null!==o;){if(window.getComputedStyle(o).getPropertyValue(t)===n)return o;o=o.parentElement}return null}function p(e){const t=e.getBoundingClientRect(),n=window.pageYOffset||document.documentElement.scrollTop;return{top:t.top+n}}const u={getItem(e){try{return null===localStorage.getItem(e)?sessionStorage.getItem(e):localStorage.getItem(e)}catch(e){return!1}},setItem(e,t){try{localStorage.setItem(e,t)}catch(n){sessionStorage.setItem(e,t)}return!0},removeItem(e){try{localStorage.removeItem(e)}catch(t){sessionStorage.removeItem(e)}return!0}};function g(e){const t="data-sa11y-pulse-border";e.setAttribute(t,""),setTimeout((()=>{e.removeAttribute(t)}),2500)}function m(e){return String(e).replace(/([^0-9a-zA-Z])/g,"").substring(0,256)}function f(){const e=document.querySelector("sa11y-control-panel").shadowRoot,t=e.getElementById("panel-alert"),n=e.getElementById("panel-alert-text"),o=e.getElementById("panel-alert-preview");for(t.classList.remove("active"),o.classList.remove("panel-alert-preview");n.firstChild;)n.removeChild(n.firstChild);for(;o.firstChild;)o.removeChild(o.firstChild)}function b(e,t,n){f();const o=document.querySelector("sa11y-control-panel").shadowRoot,i=o.getElementById("panel-alert"),a=o.getElementById("panel-alert-text"),r=o.getElementById("panel-alert-preview"),s=o.getElementById("close-alert"),l=o.getElementById("skip-button");i.classList.add("active"),a.innerHTML=e;const d=n?`<div class="element-preview">${n}</div>`:"";function c(){f();(l.hasAttribute("disabled")?o.getElementById("toggle"):l).focus()}t&&(r.classList.add("panel-alert-preview"),r.innerHTML=`${d}<div class="preview-message">${t}</div>`),setTimeout((()=>{s.focus()}),300),s.addEventListener("click",c),i.onkeydown=e=>{"Escape"===(e||window.event).key&&i.classList.contains("active")&&c()}}function h(e,t){e.forEach((e=>{o(`[${e}]`,`${t}`).forEach((t=>{t.removeAttribute(e)}))}))}function y(e,t){o(`${e}`,`${t}`).forEach((e=>{e.parentNode.removeChild(e)}))}function v(e,t,n){setTimeout((()=>{e.scrollHeight>t.clientHeight?(t.classList.add("scrollable"),e.setAttribute("tabindex","0"),n&&(e.setAttribute("aria-label",n),e.setAttribute("role","region"))):t.classList.remove("scrollable")}),50)}function x(e){const t=e.element,n=`<pre><code>${a(e.htmlPath)}</code></pre>`,o={IMG:e=>{const t=e.closest("a[href]"),o=e.alt?`alt="${r(e.alt)}"`:"alt",i=e.src,a=e.getAttribute("data-src"),s=a&&a.length>3?a:i;return i?t?`<a href="${t.href}" rel="noopener noreferrer"><img src="${s}" ${o}/></a>`:`<img src="${s}" ${o}/>`:n},IFRAME:e=>{const t=e.src,o=e.title?e.title:"",i=e.getAttribute("aria-label");if(t){return`<iframe src="${t}" aria-label="${r(i||""||o)}"></iframe>`}return n},AUDIO:()=>e.htmlPath,VIDEO:()=>e.htmlPath}[t.tagName];return o?o(t):n}const w=function(){const e={};const t={};return{initializeElements:function(t){e.Images=o("img","root",n.Exclusions.Images),e.Headings=o('h1, h2, h3, h4, h5, h6, [role="heading"][aria-level]',"document",n.Exclusions.Headings),e.HeadingOne=o('h1, [role="heading"][aria-level="1"]',"document",n.Exclusions.Headings),e.Links=o("a[href]","root",n.Exclusions.Links),e.Inputs=o("input, select, textarea","root",n.Exclusions.Container),e.Contrast=o("*","root",n.Exclusions.Contrast),e.Labels=o("label","root",n.Exclusions.Container),e.Readability=o("p, li","readability",n.Exclusions.Readability),e.Paragraphs=o("p:not(table p)","root",n.Exclusions.Container),e.Lists=o("li","root",n.Exclusions.Container),e.Spans=o("span","root",n.Exclusions.Container),e.Blockquotes=o("blockquote","root",n.Exclusions.Container),e.Tables=o('table:not([role="presentation"])',"root",n.Exclusions.Container),e.StrongItalics=o("strong, em","root",n.Exclusions.Container),e.Underlines=o("u","root",n.Exclusions.Container),e.Subscripts=o("sup, sub","root",n.Exclusions.Container),e.Language=n.Global.html.getAttribute("lang"),e.CustomErrorLinks=t.linksToFlag?o(t.linksToFlag,"root",n.Exclusions.Container):[],e.iframes=o("iframe:not(hidden), audio, video","root",n.Exclusions.Container),e.Videos=e.iframes.filter((e=>e.matches(n.EmbeddedContent.Video))),e.Audio=e.iframes.filter((e=>e.matches(n.EmbeddedContent.Audio))),e.Visualizations=e.iframes.filter((e=>e.matches(n.EmbeddedContent.Visualization))),e.EmbeddedContent=e.iframes.filter((e=>!e.matches(n.EmbeddedContent.All)))},Found:e,initializeAnnotations:function(){t.Array=o("sa11y-annotation","document"),t.Array.forEach(((e,t)=>{e.setAttribute("data-sa11y-position",t)}))},Annotations:t}}();const E=e=>{const t=document.createElement("style");t.setAttribute("class","sa11y-css-utilities"),t.textContent="[data-sa11y-overflow]{overflow:auto!important}[data-sa11y-clone-image-text]{display:none!important}[data-sa11y-readability-period]{clip:rect(1px,1px,1px,1px)!important;border:0!important;clip-path:inset(50%)!important;display:block!important;height:1px!important;overflow:hidden!important;padding:0!important;position:absolute!important;white-space:nowrap!important;width:1px!important}[data-sa11y-error]{outline:5px solid var(--sa11y-error)!important}[data-sa11y-warning]{outline:5px solid var(--sa11y-warning)!important}[data-sa11y-good]{outline:5px solid var(--sa11y-good)!important}[data-sa11y-error-inline]{background-color:var(--sa11y-error)!important;box-shadow:0 0 0 4px var(--sa11y-error)!important;color:var(--sa11y-error-text)!important}[data-sa11y-error-inline],[data-sa11y-warning-inline]{border-color:transparent!important;border-radius:.25em!important}[data-sa11y-warning-inline]{background-color:var(--sa11y-warning)!important;box-shadow:0 0 0 4px var(--sa11y-warning)!important;color:var(--sa11y-warning-text)!important}[data-sa11y-pulse-border]{animation:pulse 2s 3;box-shadow:0;outline:5px solid var(--sa11y-focus-color)!important}[data-sa11y-pulse-border]:focus,[data-sa11y-pulse-border]:hover{animation:none}@keyframes pulse{0%{box-shadow:0 0 0 5px var(--sa11y-focus-color)}70%{box-shadow:0 0 0 12px var(--sa11y-pulse-color)}to{box-shadow:0 0 0 5px var(--sa11y-pulse-color)}}@media (prefers-reduced-motion:reduce){[data-sa11y-pulse-border]{animation:none!important}}@media (forced-colors:active){[data-sa11y-error-inline],[data-sa11y-error],[data-sa11y-good],[data-sa11y-pulse-border],[data-sa11y-warning-inline],[data-sa11y-warning]{forced-color-adjust:none}}",e.shadowRoot.appendChild(t)};function A(e,t,n){if(!0===e){let e=window.location.href;const o=function(e,t){let n=null;return(...o)=>{window.clearTimeout(n),n=window.setTimeout((()=>{e(...o)}),t)}}((async()=>{e!==window.location.href&&("Closed"!==u.getItem("sa11y-remember-panel")&&u.getItem("sa11y-remember-panel")?(n(!1),await t()):t(),e=window.location.href)}),250);window.addEventListener("click",o),window.addEventListener("keydown",o)}}let k,I;function L(e,i,a,r){if(n.Global.dismissAnnotations){I=n=>{(async(e,n,i,a)=>{let r=JSON.parse(u.getItem("sa11y-dismissed"));const s=e.target;if(document.querySelector("sa11y-dismiss-tooltip").hidden=!1,"BUTTON"===s.tagName&&s.hasAttribute("data-sa11y-dismiss")){const e=parseInt(s.getAttribute("data-sa11y-dismiss"),10),l=n.find((t=>t.id===e));if(null===r&&(setTimeout((()=>b(t._("DISMISS_REMINDER"))),0),r=[]),l.dismiss){const e={key:l.dismiss,href:window.location.pathname},t=o(`[data-sa11y-annotation='${l.id}']`),n=t[0]?t[0].getAttribute("data-sa11y-position"):0;u.setItem("sa11y-latest-dismissed",n),u.setItem("sa11y-dismiss-item",JSON.stringify(e)),r.push(e),u.setItem("sa11y-dismissed",JSON.stringify(r)),u.removeItem("sa11y-dismiss-item"),null!==s.closest("[data-tippy-root]")&&s.closest("[data-tippy-root]").remove(),a(!1),await i()}}})(n,e,a,r)};document.querySelector("sa11y-tooltips").shadowRoot.addEventListener("click",I),n.Panel.panel.addEventListener("click",I)}k=()=>{(async(e,t,o)=>{document.querySelector("sa11y-dismiss-tooltip").hidden=!0;const i=e.filter((e=>e.href!==window.location.pathname));u.setItem("sa11y-dismissed",JSON.stringify(i)),n.Panel.dismissButton.classList.remove("active"),o(!1),await t()})(i,a,r)},n.Panel.dismissButton?.addEventListener("click",k)}var T=':root{--font-primary:system-ui,"Segoe UI",roboto,helvetica,arial,sans-serif;--font-secondary:Consolas,monaco,"Ubuntu Mono","Liberation Mono","Courier New",Courier,monospace;--body-text:#333;--bg-primary:#fff;--bg-secondary:#f6f8fa;--bg-tertiary:#d7d7d7;--link-primary:#004c9b;--red-text:#d30017}@media (prefers-color-scheme:dark){:root{--body-text:#dde8ff;--bg-primary:#0a2051;--bg-secondary:#072c7c;--bg-tertiary:#0041c9;--link-primary:#64b2ff;--red-text:#fe5b5f}}*{margin:0;padding:0}article,aside,nav,ol,p,pre,section,ul{margin-bottom:1rem}body{background:var(--bg-primary);font-family:var(--font-primary);font-size:1rem;line-height:1.5;margin:0 auto;max-width:70ch;overflow-wrap:break-word;overflow-x:hidden;padding:2rem;word-break:break-word}body,h1,h2,h3{color:var(--body-text)}h1,h2,h3{line-height:1;margin-bottom:8px;padding-bottom:2px;padding-top:.875rem}h1{font-size:2.25rem}h2{font-size:1.85rem}h3{font-size:1.55rem}a{color:var(--link-primary)}a:focus,a:hover{text-decoration:none}footer,header{background:var(--bg-secondary);padding:2rem calc(50vw - 50%)}header{border-bottom:1px solid var(--bg-tertiary);margin:-2rem calc(-50vw + 50%) 2rem}footer{border-top:1px solid var(--bg-tertiary);margin:3rem calc(-50vw + 50%) -2rem;text-align:center}header>:first-child{margin-top:0;padding-top:0}header>:last-child{margin-bottom:0}code,kbd,pre,samp{background:var(--bg-secondary);border:1px solid var(--bg-tertiary);border-radius:4px;font-family:var(--font-secondary);font-size:.9rem;padding:3px 6px}pre{display:block;max-width:100%;overflow:auto;padding:1rem 1.4rem}code pre,pre code{background:inherit;border:0;color:inherit;font-size:inherit;margin:0;padding:0}code pre{display:inline}details{background:var(--bg-primary);border:2px solid var(--link-primary);border-radius:4px;padding:.6rem 1rem}summary{cursor:pointer;font-weight:700}details[open]{padding-bottom:.75rem}details[open] summary{margin-bottom:6px}details[open]>:last-child{margin-bottom:0}.two-columns{display:flex}.column{flex:1;margin-inline-end:20px}.count{max-width:220px}.column dl{width:100%}dl{padding-top:10px}dt{font-weight:700}dd{padding-bottom:10px}ol ol,ol ul,ul ol,ul ul{margin-bottom:0}ul li{margin-bottom:.5rem}ol,ul{padding-left:2rem}li li:has(pre,img,iframe,video,audio){list-style:none;margin-top:1rem}ol li:not(li li){margin-bottom:3rem}iframe,img{border:1px solid var(--bg-tertiary);display:block;max-width:50%}audio,video{border:0;display:block}.red-text{color:var(--red-text)}.visually-hidden{clip:rect(1px,1px,1px,1px);border:0;clip-path:inset(50%);display:block;height:1px;overflow:hidden;padding:0;position:absolute;white-space:nowrap;width:1px}';function _(){const e=new Date,t=String(e.getDate()).padStart(2,"0"),n=String(e.getMonth()+1).padStart(2,"0"),o=e.getFullYear(),i=(new Date).toLocaleString(),a=`${n}-${t}-${o}`,r=document.querySelector("head title"),s=!r||0===r.textContent.trim().length;return{date:i,numericDate:a,titleCheck:s,metaTitle:s?"":r.textContent,pageURL:window.location.href}}function S(e,n){const o=function(e,n){const o=e.filter((e=>"error"===e.type)),i=e.filter((e=>"warning"===e.type)),r={error:o.length,warning:i.length,dismiss:n.length};function s(e,n){const o={error:t._("ERRORS"),warning:t._("WARNINGS"),dismissed:t._("DISMISSED")}[n];if(!(e.length>0))return"";let i=`<h2>${o}</h2>`,s="<ol>",l="</ol>";return"dismissed"===n&&(s=`<details><summary>${t.sprintf("PANEL_DISMISS_BUTTON",r.dismiss)}</summary><ol>`,l="</details>"),i+=s,e.forEach((e=>{let n="";e.element&&(n=["IMG","IFRAME","AUDIO","VIDEO"].includes(e.element.tagName)?`\n              <li>\n                <strong>${t._("PREVIEW")}:</strong>\n                ${x(e)}\n              </li>\n              <li>\n                <strong>${t._("ELEMENT")}:</strong>\n                <pre><code>${a(e.htmlPath)}</code></pre>\n              </li>`:`\n              <li>\n                <strong>${t._("ELEMENT")}:</strong>\n                <pre><code>${a(e.htmlPath)}</code></pre>\n              </li>`);const o=e.cssPath?`<li>\n            <strong>${t._("PATH")}:</strong>\n            <pre><code>${e.cssPath}</code></pre>\n          </li>`:"";i+=`<li>\n                <p>${e.content.replace('<hr aria-hidden="true">'," | ")}</p>\n                <ul>${n}${o}</ul>\n              </li>`})),i+=l,i}const l=s(o,"error"),d=s(i,"warning"),c=s(n,"dismissed"),p=_(),u=p.titleCheck?"":`<dt>${t._("PAGE_TITLE")}</dt><dd>${p.metaTitle}</dd>`,g=0!==r.error?`<dt>${t._("ERRORS")}</dt><dd>${r.error}</dd>`:"",m=0!==r.warning?`<dt>${t._("WARNINGS")}</dt><dd>${r.warning}</dd>`:"",f=0!==r.dismiss?`<dt>${t._("DISMISSED")}</dt><dd>${r.dismiss}</dd>`:"";return`\n      <!DOCTYPE html>\n      <html lang="${t._("LANG_CODE")}">\n      <head>\n        <meta charset="UTF-8">\n        <meta name="viewport" content="width=device-width, initial-scale=1.0">\n        <title>${t._("RESULTS")}: ${p.metaTitle}</title>\n        <style>${T}</style>\n      </head>\n      <body>\n        <header>\n          <h1>${t._("RESULTS")}</h1>\n          <dl class="two-columns">\n            <div class="column">\n              ${u}\n              <dt>URL</dt>\n              <dd><a href="${p.pageURL}">${p.pageURL}</a></dd>\n              <dt>${t._("DATE")}</dt>\n              <dd>${p.date}</dd>\n            </div>\n            <div class="column count">\n              ${g}\n              ${m}\n              ${f}\n            </div>\n        </dl>\n        </header>\n        ${l}\n        ${d}\n        ${c}\n        <footer>\n          <p>${t.sprintf("GENERATED",'<a href="https://sa11y.netlify.app">Sa11y</a>')}</p>\n        </footer>\n      </body>\n      </html>\n    `}(e,n),i=_(),r=new Blob([o],{type:"text/html"}),s=document.createElement("a"),l=i.titleCheck?"":`_${i.metaTitle.trim().replace(/ /g,"")}`;s.href=window.URL.createObjectURL(r),s.download=`Sa11y_${i.numericDate+l}.html`,document.body.appendChild(s),s.click(),setTimeout((()=>{document.body.removeChild(s),window.URL.revokeObjectURL(s.href)}),100)}function P(e){const t=_(),n=e.filter((e=>"warning"===e.type||"error"===e.type)).map((e=>{const{type:n,content:o,htmlPath:i,cssPath:a}=e,r=o.replaceAll(/<span\s+class="visually-hidden"[^>]*>.*?<\/span>/gi,"").replaceAll('<hr aria-hidden="true">'," | ").replaceAll(/"/g,'""');const s=function(e){return e.replace(/&(#?[a-zA-Z0-9]+);/g,((e,t)=>{switch(t){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":case"#39":return"'";default:return"#"===t.charAt(0)?String.fromCharCode("x"===t.charAt(1)?parseInt(t.substr(2),16):parseInt(t.substr(1),10)):e}}))}(String(r).replace(/<[^>]*>/g,"")),l={Title:`"${t.metaTitle}"`,URL:`"${t.pageURL}"`,Type:`"${String(n)}"`,Issue:`"${s}"`,Element:`"${i}"`};return a&&(l.Path=`"${a}"`),l})),o=Object.keys(n[0]),i=`${o.join(",")}\n${n.map((e=>o.map((t=>e[t])).join(","))).join("\n")}`,a=new Uint8Array([239,187,191]),r=new Blob([a,i],{type:"text/csv;charset=utf-8;"}),s=window.URL.createObjectURL(r),l=document.createElement("a");l.href=s,l.href=window.URL.createObjectURL(r);const d=t.titleCheck?"":`_${t.metaTitle.trim().replace(/ /g,"")}`;l.setAttribute("download",`Sa11y_${t.numericDate+d}.csv`),document.body.appendChild(l),l.click(),setTimeout((()=>{document.body.removeChild(l),window.URL.revokeObjectURL(l.href)}),100)}let C,$;var O='.visually-hidden{clip:rect(1px,1px,1px,1px);border:0;clip-path:inset(50%);display:block;height:1px;overflow:hidden;padding:0;position:absolute;white-space:nowrap;width:1px}[hidden]{display:none!important}.header-text,.header-text-inline,h2{color:var(--sa11y-panel-primary);display:block;font-size:var(--sa11y-large-text);font-weight:600;margin-bottom:3px}.header-text-inline{display:inline-block!important}code{font-family:monospace!important}.kbd,code,kbd{background-color:var(--sa11y-panel-badge);border-radius:3.2px;color:var(--sa11y-panel-primary);padding:1.6px 4.8px}.bold{font-weight:600}.red-text{color:var(--sa11y-red-text)}.red-text,.yellow-text{font-family:var(--sa11y-font-face)}.yellow-text{color:var(--sa11y-yellow-text)}.badge{background-color:var(--sa11y-panel-badge);border:1px solid transparent;border-radius:10px;color:var(--sa11y-panel-primary);display:inline;font-size:13px;font-weight:700!important;line-height:1;min-width:10px;padding:1px 4.5px 1.75px;text-align:center;vertical-align:baseline;white-space:nowrap}.error-badge{background:var(--sa11y-error);color:var(--sa11y-error-text)}.warning-badge{background:var(--sa11y-yellow-text);color:var(--sa11y-panel-bg)}.close-btn{background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:50%;color:var(--sa11y-panel-primary);cursor:pointer;float:var(--sa11y-float-rtl);font-size:var(--sa11y-normal-text);font-weight:400;height:32px;margin:0;position:relative;transition:all .2s ease-in-out;width:32px}.close-btn:focus,.close-btn:hover{background-color:var(--sa11y-shortcut-hover)}.close-btn:after{background:var(--sa11y-setting-switch-bg-off);bottom:-7px;content:"";left:-7px;-webkit-mask:var(--sa11y-close-btn-svg) center no-repeat;mask:var(--sa11y-close-btn-svg) center no-repeat;position:absolute;right:-7px;top:-7px}@media screen and (forced-colors:active){.close-btn:after{filter:invert(1)}}#container [tabindex="-1"]:focus,#container [tabindex="0"]:focus,#container a:focus,#container button:not(#panel-controls button):not(.switch):focus,#container select:focus{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}#container #panel-controls button:focus,#container .switch:focus{box-shadow:inset 0 0 0 4px var(--sa11y-focus-color);outline:0}#container #panel-controls button:focus:not(:focus-visible),#container [tabindex="-1"]:focus:not(:focus-visible),#container [tabindex="0"]:focus:not(:focus-visible),#container button:focus:not(:focus-visible),#container select:focus:not(:focus-visible){box-shadow:none;outline:0}#container [tabindex="-1"]:focus-visible,#container [tabindex="0"]:focus-visible,#container a:focus-visible,#container button:not(#panel-controls button):not(.switch):focus-visible,#container select:focus-visible{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}#container #panel-controls button:focus-visible,#container .switch:focus-visible{box-shadow:inset 0 0 0 4px var(--sa11y-focus-color);outline:0}@media screen and (forced-colors:active){#panel-controls button:focus{border:3px solid transparent}#container [tabindex="-1"]:focus,#container [tabindex="0"]:focus,#container a:focus,#container button:focus,#container select:focus,.close-btn:focus{outline:3px solid transparent!important}}';class N extends HTMLElement{constructor(e){super(),this.error=e}connectedCallback(){const e=this.attachShadow({mode:"open"}),o=document.createElement("style");o.innerHTML=":host{background:var(--sa11y-panel-bg);border-top:5px solid var(--sa11y-panel-bg-splitter);bottom:0;display:block;height:-moz-fit-content;height:fit-content;left:0;position:fixed;right:0;width:100%;z-index:999999}*{-webkit-font-smoothing:auto!important;color:var(--sa11y-panel-primary);font-family:var(--sa11y-font-face)!important;font-size:var(--sa11y-normal-text);line-height:22px!important}#dialog{margin:20px auto;max-width:900px;padding:20px}h2{font-size:var(--sa11y-large-text);margin-top:0}a{color:var(--sa11y-hyperlink);cursor:pointer;text-decoration:underline}a:focus,a:hover{text-decoration:none}p{margin-top:0}.error{background:var(--sa11y-error);border:2px dashed #f08080;color:var(--sa11y-error-text);margin-bottom:0;padding:5px}"+O,e.appendChild(o);const i=document.createElement("div");i.setAttribute("id","dialog"),i.setAttribute("tabindex","-1");const r=window.location,s=`https://github.com/ryersondmp/sa11y/issues/new?title=Bug%20report&body=%23%23%20Error%20Description%0A%60%60%60javascript%0A${encodeURIComponent(this.error.stack)}%0A%60%60%60%0A%0A%23%23%20URL%0A%60${r}%60%0A%0A%23%23%20Comments%0A`;i.innerHTML=`\n      <button class="close-btn" aria-label="${t._("ALERT_CLOSE")}"></button>\n      <h2>${t._("ERROR")}</h2>\n      <p>${t.sprintf("CONSOLE_ERROR_MESSAGE","https://forms.gle/sjzK9XykETaoqZv99",s)}</p>\n      <p class="error">${a(this.error.stack)}<br><br>URL: ${r}</p>\n    `,e.appendChild(i),setTimeout((()=>{n.Panel.toggle.style.display="none";const e=document.querySelector("sa11y-console-error");e.shadowRoot.getElementById("dialog").focus();e.shadowRoot.querySelector(".close-btn").addEventListener("click",(()=>{e.remove()}))}),0)}}class R extends HTMLElement{connectedCallback(){this.attachShadow({mode:"open"});const e=document.createElement("style");e.textContent='a,button,code,div,h1,h2,kbd,label,li,ol,p,pre,span,strong,svg,ul{all:unset;box-sizing:border-box!important}:after,:before{all:unset}div{display:block}*{-webkit-font-smoothing:auto!important;font-family:var(--sa11y-font-face)!important}label,li,ol,p,ul{font-size:var(--sa11y-normal-text);font-weight:400;letter-spacing:normal;line-height:22px!important;text-align:start;word-break:break-word}.sa11y-overflow{overflow:auto}iframe,img,video{border:0;display:block;height:auto;max-width:100%}audio{max-width:100%}#toggle{align-items:center;background:linear-gradient(0deg,#e040fb,#00bcd4);background-color:var(--sa11y-setting-switch-bg-off);background-size:150% 150%;border-radius:50%;bottom:15px;color:#fff;cursor:pointer;display:flex;height:55px;inset-inline-end:18px;justify-content:center;margin:0;overflow:visible;position:fixed;transition:all .2s ease-in-out;width:55px;z-index:2147483644}#toggle.left,#toggle.top-left{inset-inline-start:18px}#toggle.top-left,#toggle.top-right{bottom:unset;top:15px}@media screen and (forced-colors:active){#toggle{background:ButtonFace!important;border:2px solid transparent}}#toggle svg{height:35px;width:35px}#toggle svg path{fill:var(--sa11y-panel-bg)}#toggle:focus,#toggle:hover{animation:sa11y-toggle-gradient 3s ease}#toggle:disabled:focus,#toggle:disabled:hover{animation:none}#toggle.on{background:linear-gradient(180deg,#e040fb,#00bcd4)}#toggle:disabled{background:unset;background-color:var(--sa11y-setting-switch-bg-off);cursor:not-allowed}#notification-badge{text-wrap:nowrap;align-items:center;background-color:#eb0000;border:1px solid transparent;border-radius:12px;color:#fff;display:none;font-size:13.5px;font-weight:400;justify-content:center;line-height:1;padding:2.5px;position:absolute;right:-3px;top:-5.5px}#notification-badge.notification-badge-warning{background-color:var(--sa11y-warning-hover);border:1px solid var(--sa11y-warning);color:var(--sa11y-warning-text)}#panel{background:var(--sa11y-panel-bg);border-radius:4px;bottom:25px;box-shadow:0 0 20px 4px rgba(154,161,177,.15),0 4px 80px -8px rgba(36,40,47,.25),0 4px 4px -2px rgba(91,94,105,.15);inset-inline-end:42px;opacity:0;overflow:visible;position:fixed;transform:scale(0);transform-origin:100% 100%;transition:transform .2s,opacity background .2s .2s;visibility:hidden;z-index:2147483643}#panel.left,#panel.top-left{inset-inline-start:42px}#panel.top-left,#panel.top-right{bottom:unset;top:35px}#panel.active{height:auto;opacity:1;transform:scale(1);transform-origin:bottom right;transition:transform .2s,opacity .2s;visibility:visible}@media screen and (forced-colors:active){#panel{border:2px solid transparent}}#panel.active.left,[dir=rtl] #panel.active{transform-origin:bottom left}#panel.active.top-left{transform-origin:top left}#panel.active.top-right{transform-origin:top right}#panel-alert{display:none;opacity:0}#panel-alert.active{display:block;opacity:1}#panel-alert-content{align-items:center;border-bottom:1px solid var(--sa11y-panel-bg-splitter);color:var(--sa11y-panel-primary);max-height:400px;overflow-y:auto;padding:15px 20px 15px 15px;position:relative}.top-left #panel-alert-content,.top-right #panel-alert-content{border:0}#panel-alert-preview .close-tooltip{display:none}#panel-alert-preview,#panel-alert-text{font-family:var(--sa11y-font-face);font-size:var(--sa11y-normal-text);font-weight:400;line-height:22px}.panel-alert-preview{background:var(--sa11y-panel-bg-secondary);border:1px dashed var(--sa11y-panel-bg-splitter);border-radius:5px;margin-top:15px;padding:10px}.element-preview{background-color:var(--sa11y-panel-badge);border-radius:3.2px;margin-bottom:10px;overflow-wrap:break-word;padding:5px}button[data-sa11y-dismiss]{background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:5px;color:var(--sa11y-panel-primary);cursor:pointer;display:block;margin:10px 5px 5px 0;padding:4px 8px}button[data-sa11y-dismiss]:focus,button[data-sa11y-dismiss]:hover{background:var(--sa11y-shortcut-hover)}h2{display:block;font-size:var(--sa11y-large-text);margin-bottom:3px}h2,strong{font-weight:600}a:not(#outline-list a):not(.edit){border-bottom:0;color:var(--sa11y-hyperlink);cursor:pointer;text-decoration:underline}a:focus,a:hover{text-decoration:none!important}hr{background:var(--sa11y-panel-bg-splitter);border:none;height:1px;margin:10px 0;opacity:1;padding:0}#dismiss-button,#skip-button{background:var(--sa11y-panel-bg-secondary);border:1px solid var(--sa11y-button-outline);border-radius:50px;cursor:pointer;display:none;height:36px;margin-inline-end:8px;margin-inline-start:2px;overflow:visible;position:relative;text-align:center;transition:all .1s ease-in-out;width:36px}#dismiss-button.active,#skip-button.active{display:block}#dismiss-button:disabled,#skip-button:disabled{background:none;border:0;box-shadow:none;cursor:default}#dismiss-button:before,#skip-button:before{bottom:-5px;content:"";left:-5px;position:absolute;right:-5px;top:-5px}#dismiss-button:focus:not(:disabled),#dismiss-button:hover:not(:disabled),#skip-button:focus:not(:disabled),#skip-button:hover:not(:disabled){background-color:var(--sa11y-shortcut-hover)}#panel.left #dismiss-button,#panel.left #skip-button,#panel.top-left #dismiss-button,#panel.top-left #skip-button{margin-inline-end:2px;margin-inline-start:8px}.dismiss-icon{background:var(--sa11y-setting-switch-bg-off);display:inline-block;height:24px;margin-bottom:-4px;-webkit-mask:var(--sa11y-dismiss-icon) center no-repeat;mask:var(--sa11y-dismiss-icon) center no-repeat;width:24px}@media screen and (forced-colors:active){.dismiss-icon{filter:invert(1)}}#panel-content{align-items:center;color:var(--sa11y-panel-primary);display:flex;padding:6px}#panel-content.errors .panel-icon,#panel-content.good .panel-icon,#panel-content.warnings .panel-icon{height:26px;margin:0 auto;width:26px}#panel-content.errors .panel-icon{background:var(--sa11y-panel-error);margin-top:-2px;-webkit-mask:var(--sa11y-error-svg) center no-repeat;mask:var(--sa11y-error-svg) center no-repeat}#panel-content.good .panel-icon{background:var(--sa11y-good);-webkit-mask:var(--sa11y-good-svg) center no-repeat;mask:var(--sa11y-good-svg) center no-repeat}#panel-content.warnings .panel-icon{background:var(--sa11y-warning-svg-color);-webkit-mask:var(--sa11y-warning-svg) center no-repeat;mask:var(--sa11y-warning-svg) center no-repeat;transform:scaleX(var(--sa11y-icon-direction))}@media screen and (forced-colors:active){#panel-content.errors .panel-icon,#panel-content.good .panel-icon,#panel-content.warnings .panel-icon{filter:invert(1)}}#panel.left #panel-content,#panel.top-left #panel-content{flex-direction:row-reverse}#status{font-size:var(--sa11y-large-text)}#status,.panel-count{color:var(--sa11y-panel-primary)}.panel-count{background-color:var(--sa11y-panel-badge);border-radius:4px;font-size:15px;font-weight:400;margin-left:3px;margin-right:3px;padding:2px 4px}#images-panel,#outline-panel,#page-issues,#settings-panel{color:var(--sa11y-panel-primary);display:none;opacity:0}#images-panel.active,#outline-panel.active,#page-issues.active,#settings-panel.active{display:block;opacity:1}.panel-header{padding:10px 15px 0;text-align:start}#about-content{padding-top:5px}#about-content p{display:block;margin-block-end:1em}#images-content,#outline-content,#page-issues-content,#settings-content{border-bottom:1px solid var(--sa11y-panel-bg-splitter);padding:0 15px 10px}.top-left #images-content,.top-left #outline-content,.top-left #page-issues-content,.top-left #settings-content,.top-right #images-content,.top-right #outline-content,.top-right #page-issues-content,.top-right #settings-content{border:0}#page-issues-content{max-height:160px;overflow-y:auto}#settings-content{max-height:400px;overflow-y:auto}#images-content,#outline-content{max-height:250px;overflow-y:auto}#outline-panel .outline-list-item.sa11y-red-text,#settings-panel .sa11y-red-text{color:var(--sa11y-red-text)}#outline-list{display:block;margin:0;padding:0}#outline-list a{cursor:pointer;display:block;text-decoration:none}#outline-list li{display:block;list-style-type:none;margin-bottom:3px;margin-top:0;padding:0}#outline-list li:first-child{margin-top:5px}#outline-list li a:focus,#outline-list li a:hover{background:var(--sa11y-panel-outline-hover);border-radius:5px;box-shadow:0 0 0 2px var(--sa11y-panel-outline-hover);display:block}#outline-list .outline-2{margin-inline-start:15px}#outline-list .outline-3{margin-inline-start:30px}#outline-list .outline-4{margin-inline-start:45px}#outline-list .outline-5{margin-inline-start:60px}#outline-list .outline-6{margin-inline-start:75px}#images-list{display:block;margin:0;padding:0}#images-list li{border-bottom:1px solid var(--sa11y-panel-bg-splitter);display:block;list-style-type:none;margin:15px 0;overflow:hidden;width:100%}#images-list li:first-child{margin-top:5px}#images-list li:last-child{border:none;margin-bottom:0}#images-list li .alt{padding:2px 5px 10px}#images-list li .edit{background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:5px;color:var(--sa11y-panel-primary);cursor:pointer;padding:4px 7px;position:relative;text-decoration:none}#images-list li .edit:focus,#images-list li .edit:hover{background-color:var(--sa11y-shortcut-hover)}#images-list li .edit:before{bottom:-10px;content:"";left:-10px;position:absolute;right:-10px;top:-10px}#images-list li img{border-radius:5px;float:inline-start;margin-block-end:15px;margin-inline-end:10px;max-width:110px}#images-list li.warning .alt{color:var(--sa11y-yellow-text)}#images-list li.warning img{background-color:var(--sa11y-yellow-text);border:5px solid var(--sa11y-yellow-text)}#images-list li.error .alt{color:var(--sa11y-error)}#images-list li.error img{background-color:var(--sa11y-error);border:5px solid var(--sa11y-error)}#images-list li.good img{background-color:var(--sa11y-panel-badge);border:5px solid var(--sa11y-panel-badge)}@media screen and (forced-colors:active){#images-list li img{background-color:ButtonBorder!important}}.error-icon{background:var(--sa11y-error-text);display:inline-block;height:16px;margin-bottom:-4px;-webkit-mask:var(--sa11y-error-svg) center no-repeat;mask:var(--sa11y-error-svg) center no-repeat;width:16px}.hidden-icon{margin-bottom:-3px;-webkit-mask:var(--sa11y-hidden-icon-svg) center no-repeat;mask:var(--sa11y-hidden-icon-svg) center no-repeat}.hidden-icon,.link-icon{background:var(--sa11y-panel-primary);display:inline-block;height:16px;width:16px}.link-icon{margin-bottom:-3.5px;-webkit-mask:var(--sa11y-link-icon-svg) center no-repeat;mask:var(--sa11y-link-icon-svg) center no-repeat}.error-badge .hidden-icon,.error-badge .link-icon{background:var(--sa11y-error-text)}.warning-badge .hidden-icon,.warning-badge .link-icon{background:var(--sa11y-panel-bg)}@media screen and (forced-colors:active){.error-icon,.hidden-icon,.link-icon{filter:invert(1)}}#panel-controls{border-radius:0 0 4px 4px;display:flex;overflow:hidden}#panel-controls button{background:var(--sa11y-panel-bg-secondary);background-color:var(--sa11y-panel-bg-secondary);border-bottom:1px solid var(--sa11y-panel-bg-splitter);border-inline-end:1px solid var(--sa11y-panel-bg-splitter);border-top:1px solid var(--sa11y-panel-bg-splitter);color:var(--sa11y-panel-secondary);cursor:pointer;display:block;font-size:var(--sa11y-normal-text);font-weight:400;height:30px;line-height:0;margin:0;opacity:1;outline:0;padding:0;position:relative;text-align:center;transition:background .2s;width:100%}#panel-controls button.active,#panel-controls button:hover{background-color:var(--sa11y-shortcut-hover)}#panel-controls button.active{font-weight:500}#export-results-mode,label{color:var(--sa11y-panel-primary);display:inline-block;font-weight:400;margin:0;width:100%}label:not(#colour-filter-mode,#export-results-mode){cursor:pointer}#settings-panel #export-csv,#settings-panel #export-html{padding:0;text-align:center;width:unset}#settings-panel #export-csv span,#settings-panel #export-html span{background:var(--sa11y-panel-bg-secondary);border-radius:5px;box-shadow:inset 0 0 0 2px var(--sa11y-setting-switch-bg-off);display:block;margin:0 4px;padding:7px 9px;width:65px}#settings-panel #export-csv:focus span,#settings-panel #export-csv:focus-within span,#settings-panel #export-csv:hover span,#settings-panel #export-html:focus span,#settings-panel #export-html:focus-within span,#settings-panel #export-html:hover span{background:var(--sa11y-shortcut-hover)}#settings-panel .switch{background:none;border:0;border-radius:5px;color:var(--sa11y-panel-primary);cursor:pointer;font-size:var(--sa11y-normal-text);font-weight:400;height:44px;margin:0;padding:7px 10px;position:relative;text-align:end;width:105px}#settings-panel .switch[aria-pressed=false]:after,#settings-panel .switch[aria-pressed=true]:after{content:"";display:inline-block;height:27px;margin:0 4px 4px;vertical-align:middle;width:27px}#settings-panel .switch[aria-pressed=true]:after{background:var(--sa11y-setting-switch-bg-on);-webkit-mask:var(--sa11y-setting-switch-on-svg) center no-repeat;mask:var(--sa11y-setting-switch-on-svg) center no-repeat}#settings-panel .switch[aria-pressed=false]:after{background:var(--sa11y-setting-switch-bg-off);-webkit-mask:var(--sa11y-setting-switch-off-svg) center no-repeat;mask:var(--sa11y-setting-switch-off-svg) center no-repeat}@media screen and (forced-colors:active){#settings-panel .switch[aria-pressed=false]:after,#settings-panel .switch[aria-pressed=true]:after{filter:invert(1)}}#settings-panel #settings-options li{align-items:center;border-bottom:1px solid var(--sa11y-panel-bg-splitter);display:flex;justify-content:space-between;list-style-type:none;padding:1px 0}#settings-panel #settings-options li:last-child{border:none}#page-issues{align-items:center;color:var(--sa11y-panel-primary)}#page-issues-list{display:block;margin-top:4px}#page-issues-list li{display:block;margin:0 0 10px}#page-issues-list strong{display:block}.top-left.has-page-issues #page-issues,.top-right.has-page-issues #page-issues{border-top:1px solid var(--sa11y-panel-bg-splitter);margin-top:-1px}#panel-colour-filters{align-items:center;color:var(--sa11y-panel-primary);display:none;font-family:var(--sa11y-font-face);font-size:var(--sa11y-normal-text);font-weight:400;line-height:22px}#panel-colour-filters.active{display:flex}#panel-colour-filters p{padding:6px 20px 6px 6px;width:100%}#panel-colour-filters[data-colour=protanopia]{border-bottom:6px solid transparent;-o-border-image:linear-gradient(94deg,#786719 11%,#e0c600 36%,#e0c600 47%,#0059e3 75%,#0042aa 91%);border-image:linear-gradient(94deg,#786719 11%,#e0c600 36%,#e0c600 47%,#0059e3 75%,#0042aa 91%);border-image-slice:1}#panel-colour-filters[data-colour=deuteranopia]{border-bottom:6px solid transparent;-o-border-image:linear-gradient(270deg,#567fdb,#a4a28d 48%,#c3ad14 69%,#a79505);border-image:linear-gradient(270deg,#567fdb,#a4a28d 48%,#c3ad14 69%,#a79505);border-image-slice:1}#panel-colour-filters[data-colour=tritanopia]{border-bottom:6px solid transparent;-o-border-image:linear-gradient(270deg,#b1506f,#0696c1 35%,#f3a9ba 70%,#d91c5d 87%,#fe015c);border-image:linear-gradient(270deg,#b1506f,#0696c1 35%,#f3a9ba 70%,#d91c5d 87%,#fe015c);border-image-slice:1}#panel-colour-filters[data-colour=monochromacy]{border-bottom:6px solid transparent;-o-border-image:linear-gradient(270deg,#000,#a7a7a7 50%,#000);border-image:linear-gradient(270deg,#000,#a7a7a7 50%,#000);border-image-slice:1}#panel-colour-filters[data-colour=protanopia] .panel-icon{background:var(--sa11y-panel-error)}#panel-colour-filters[data-colour=deuteranopia] .panel-icon{background:var(--sa11y-good-hover)}#panel-colour-filters[data-colour=tritanopia] .panel-icon{background:var(--sa11y-blue)}#panel-colour-filters[data-colour=monochromacy] .panel-icon{background:linear-gradient(90deg,#38a459 20%,red 50%,#0077c8 80%)}#panel-colour-filters .panel-icon{height:30px;margin-inline-end:5px;margin-inline-start:10px;-webkit-mask:var(--sa11y-low-vision-icon) center no-repeat;mask:var(--sa11y-low-vision-icon) center no-repeat;width:30px}@media screen and (forced-colors:active){#panel-colour-filters .panel-icon{forced-color-adjust:none}}.select-dropdown{align-items:center;display:flex;position:relative}.select-dropdown:after{border-left:5px solid transparent;border-right:5px solid transparent;border-top:5px solid var(--sa11y-setting-switch-bg-off);content:" ";inset-inline-end:14px;position:absolute}#colour-filter-select{-webkit-appearance:none;-moz-appearance:none;appearance:none;background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-setting-switch-bg-off);border-radius:5px;color:var(--sa11y-panel-primary);cursor:pointer;font-size:var(--sa11y-normal-text);font-weight:400;height:30px;margin-inline-end:4px;padding-inline-end:25px;padding-inline-start:5px;position:relative;text-align:end;vertical-align:middle}#colour-filter-select:focus,#colour-filter-select:hover{background:var(--sa11y-shortcut-hover)}#colour-filter-select.active{box-shadow:0 0 0 2px var(--sa11y-setting-switch-bg-on)}#colour-filter-item label,#colour-filter-item select{margin-bottom:9px;margin-top:10px}#readability-panel{display:none;opacity:0}#readability-panel.active{display:block;opacity:1}.top-left #readability-content,.top-right #readability-content{border-top:1px solid var(--sa11y-panel-bg-splitter)}.left #readability-content,.right #readability-content{border-bottom:1px solid var(--sa11y-panel-bg-splitter)}#readability-content{color:var(--sa11y-panel-primary);padding:10px 15px;width:100%}#readability-details{list-style-type:none;margin:0;padding:0;white-space:normal}#readability-details li{display:inline-block;list-style-type:none;margin:0;padding-inline-end:10px}.readability-score{background-color:var(--sa11y-panel-badge);border-radius:4px;color:var(--sa11y-panel-primary);margin-inline-start:5px;padding:2px 5px}#readability-info{margin-inline-start:10px}#skip-to-page-issues{display:none}#panel.has-page-issues #skip-to-page-issues{clip:rect(0,0,0,0);background:var(--sa11y-panel-bg);border:0;border-radius:5px;display:block;height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;white-space:nowrap;width:1px}#panel.has-page-issues #skip-to-page-issues:focus{clip:auto;height:auto;margin:0;overflow:visible;padding:5px 7px;white-space:normal;width:auto;z-index:1}.hide-settings-border{border-bottom:0!important;padding:0 15px!important}.hide-settings-border li:not(#colour-filter-item){display:none!important}.hide-settings-border #about-content{display:none}.hide-settings-border.scrollable:before{all:unset}::-webkit-scrollbar{height:6px;width:7px}::-webkit-scrollbar-thumb{background-color:var(--sa11y-button-outline);border-radius:6px}*{scrollbar-color:var(--sa11y-button-outline);scrollbar-width:thin}.scrollable:before{animation:fade 1s ease-in-out;background:linear-gradient(180deg,transparent 70%,var(--sa11y-panel-scrollable) 100%);background-position:bottom;bottom:auto;content:"";height:250px;left:0;position:absolute;right:0;top:auto;transition:opacity 1s ease-in-out;width:100%;z-index:-1}#settings-content.scrollable:before{height:400px}.top-left .scrollable:before,.top-right .scrollable:before{border-radius:5px}#page-issues-content.scrollable:before{height:160px}#panel-alert.scrollable:before{height:200px}@keyframes sa11y-toggle-gradient{0%{background-position:50% 0}50%{background-position:50% 100%}to{background-position:50% 0}}@keyframes fade{0%{opacity:0}to{opacity:1}}@media (prefers-reduced-motion:reduce){*{animation:none!important;transform:none!important;transition:none!important}}#panel{width:400px}#container:lang(en) #panel{width:305px}#container:lang(da) #panel,#container:lang(de) #panel,#container:lang(nb) #panel,#container:lang(pl) #panel,#container:lang(sv) #panel,#container:lang(zh) #panel{width:350px}#container:lang(bg) .switch:not(#export-results-item *),#container:lang(es) .switch:not(#export-results-item *){width:225px!important}#container:not(:lang(en)):not(:lang(de)) .switch{width:205px}'+O,this.shadowRoot.appendChild(e);const o="On"===u.getItem("sa11y-remember-contrast"),i="On"===u.getItem("sa11y-remember-labels"),a="On"===u.getItem("sa11y-remember-links-advanced"),r="On"===u.getItem("sa11y-remember-readability"),s=n.Global.checkAllHideToggles,{panelPosition:l}=n.Global,d=n.Global.contrastPlugin?`\n      <li id="contrast-item" ${s?"hidden":""}>\n        <label id="check-contrast" for="contrast-toggle">${t._("CONTRAST")}</label>\n        <button id="contrast-toggle"\n          aria-labelledby="check-contrast"\n          class="switch"\n          aria-pressed="${o?"true":"false"}">${o?t._("ON"):t._("OFF")}</button>\n      </li>`:"",c=n.Global.formLabelsPlugin?`\n      <li id="form-labels-item" ${s?"hidden":""}>\n        <label id="check-labels" for="labels-toggle">${t._("FORM_LABELS")}</label>\n        <button id="labels-toggle"\n          aria-labelledby="check-labels"\n          class="switch"\n          aria-pressed="${i?"true":"false"}">${i?t._("ON"):t._("OFF")}</button>\n      </li>`:"",p=n.Global.linksAdvancedPlugin?`\n      <li id="links-advanced-item" ${s?"hidden":""}>\n        <label id="check-changerequest" for="links-advanced-toggle">${t._("LINKS_ADVANCED")} <span class="badge">AAA</span></label>\n        <button id="links-advanced-toggle"\n          aria-labelledby="check-changerequest"\n          class="switch"\n          aria-pressed="${a?"true":"false"}">${a?t._("ON"):t._("OFF")}</button>\n      </li>`:"",g=n.Readability.Plugin?`\n      <li id="readability-item">\n        <label id="check-readability" for="readability-toggle">${t._("LANG_READABILITY")} <span class="badge">AAA</span></label>\n        <button id="readability-toggle"\n          aria-labelledby="check-readability"\n          class="switch"\n          aria-pressed="${r?"true":"false"}">${r?t._("ON"):t._("OFF")}</button>\n      </li>`:"",m=n.Global.colourFilterPlugin?`\n      <li id="colour-filter-item">\n        <label id="colour-filter-mode" for="colour-filter">${t._("COLOUR_FILTER")}</label>\n        <div class="select-dropdown">\n          <select id="colour-filter-select">\n            <option value="0">${t._("OFF")}</option>\n            <option value="1">${t._("PROTANOPIA")}</option>\n            <option value="2">${t._("DEUTERANOPIA")}</option>\n            <option value="3">${t._("TRITANOPIA")}</option>\n            <option value="4">${t._("MONOCHROMACY")}</option>\n          </select>\n        </div>\n      </li>`:"",f=n.Global.colourFilterPlugin?`\n      <div id="panel-colour-filters" role="region" aria-labelledby="colour-filter-mode">\n        <div id="filter-icon" class="panel-icon" role="img"></div>\n        <p>${t._("COLOUR_FILTER_MESSAGE")}</p>\n      </div>`:"",b=n.Global.exportResultsPlugin?`\n      <li id="export-results-item">\n        <span id="export-results-mode">${t._("EXPORT_RESULTS")}</span>\n        <button id="export-csv" class="switch" aria-describedby="export-results-mode">\n          <span>CSV</span>\n        </button>\n        <button id="export-html" class="switch" aria-describedby="export-results-mode">\n          <span>HTML</span>\n        </button>\n      </li>`:"",h=n.Global.aboutContent?`\n      <div id="about-content">\n        ${n.Global.aboutContent}\n      </div>`:"",y=`\n      <button type="button" aria-expanded="false" id="toggle" aria-describedby="notification-badge" aria-label="${t._("MAIN_TOGGLE_LABEL")}" class="${l}" disabled>\n        <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 48c114.953 0 208 93.029 208 208 0 114.953-93.029 208-208 208-114.953 0-208-93.029-208-208 0-114.953 93.029-208 208-208m0-40C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 56C149.961 64 64 149.961 64 256s85.961 192 192 192 192-85.961 192-192S362.039 64 256 64zm0 44c19.882 0 36 16.118 36 36s-16.118 36-36 36-36-16.118-36-36 16.118-36 36-36zm117.741 98.023c-28.712 6.779-55.511 12.748-82.14 15.807.851 101.023 12.306 123.052 25.037 155.621 3.617 9.26-.957 19.698-10.217 23.315-9.261 3.617-19.699-.957-23.316-10.217-8.705-22.308-17.086-40.636-22.261-78.549h-9.686c-5.167 37.851-13.534 56.208-22.262 78.549-3.615 9.255-14.05 13.836-23.315 10.217-9.26-3.617-13.834-14.056-10.217-23.315 12.713-32.541 24.185-54.541 25.037-155.621-26.629-3.058-53.428-9.027-82.141-15.807-8.6-2.031-13.926-10.648-11.895-19.249s10.647-13.926 19.249-11.895c96.686 22.829 124.283 22.783 220.775 0 8.599-2.03 17.218 3.294 19.249 11.895 2.029 8.601-3.297 17.219-11.897 19.249z"/></svg>\n        <div id="notification-badge">\n          <span id="notification-count"></span>\n          <span id="notification-text" class="visually-hidden"></span>\n        </div>\n      </button>`,v=`\n      <div id="page-issues">\n        <div class="panel-header">\n          <h2 id="page-issues-header" tabindex="-1">${t._("PAGE_ISSUES")}</h2>\n        </div>\n        <div id="page-issues-content">\n          <ul id="page-issues-list" role="list" aria-labelledby="page-issues-header"></ul>\n        </div>\n      </div>`,x=`\n      <div id="outline-panel" role="tabpanel" aria-labelledby="outline-header">\n        <div class="panel-header">\n          <h2 id="outline-header" tabindex="-1">${t._("OUTLINE")}</h2>\n        </div>\n        <div id="outline-content">\n          <ul\n            id="outline-list"\n            tabindex="0"\n            role="list"\n            aria-labelledby="outline-header"></ul>\n        </div>\n        <div id="readability-panel">\n          <div id="readability-content">\n            <h2 class="header-text-inline">${t._("LANG_READABILITY")}</h2>\n            <p id="readability-info"></p>\n            <ul id="readability-details"></ul>\n          </div>\n        </div>\n      </div>`,w=n.Global.showImageOutline?`\n      <div id="images-panel" role="tabpanel" aria-labelledby="images-header">\n        <div class="panel-header">\n          <h2 id="images-header" tabindex="-1">${t._("IMAGES")}</h2>\n        </div>\n        <div id="images-content">\n          <ul\n            id="images-list"\n            tabindex="0"\n            role="list"\n            aria-labelledby="images-header"></ul>\n        </div>\n      </div>`:"",E=`\n      <div id="settings-panel" role="tabpanel" aria-labelledby="settings-header">\n        <div class="panel-header">\n          <h2 id="settings-header" tabindex="-1">${t._("SETTINGS")}</h2>\n        </div>\n        <div id="settings-content">\n          <ul id="settings-options">\n            ${d}\n            ${c}\n            ${p}\n            ${g}\n            <li id="dark-mode-item">\n              <label id="dark-mode" for="theme-toggle">${t._("DARK_MODE")}</label>\n              <button id="theme-toggle"\n                aria-labelledby="dark-mode"\n                class="switch"></button>\n            </li>\n            ${b}\n            ${m}\n          </ul>\n          ${h}\n        </div>\n      </div>`,A=`\n      <div\n        id="panel-alert"\n        role="alertdialog"\n        aria-labelledby="alert-heading"\n        aria-describedby="panel-alert-text">\n        <div id="panel-alert-content">\n          <div class="header-text">\n            <button id="close-alert" class="close-btn" aria-label="${t._("ALERT_CLOSE")}"></button>\n            <h2 id="alert-heading">${t._("ALERT_TEXT")}</h2>\n          </div>\n          <p id="panel-alert-text"></p>\n          <div id="panel-alert-preview"></div>\n        </div>\n      </div>`,k=`\n      <div id="panel-content">\n        <button id="skip-to-page-issues" type="button">\n          ${t._("SKIP_TO_PAGE_ISSUES")}\n        </button>\n        <button id="skip-button" type="button">\n          <div class="panel-icon"></div>\n          <span class="visually-hidden">${t._("SHORTCUT_SCREEN_READER")}</span>\n        </button>\n        <button id="dismiss-button" type="button">\n          <div class="dismiss-icon"></div>\n          <span id="dismiss-tooltip" class="visually-hidden"></span>\n        </button>\n        <div id="panel-text">\n          <h1 class="visually-hidden">${t._("PANEL_HEADING")}</h1>\n          <p id="status" aria-live="polite"></p>\n        </div>\n      </div>`,I=`<button type="button" role="tab" aria-expanded="false" id="images-toggle" aria-controls="images-panel">${t._("IMAGES")}</button>`,L=n.Global.showImageOutline?'<div style="width:80px"></div>':'<div style="width:40px"></div>',T=`\n      <div id="panel-controls" role="tablist" aria-orientation="horizontal">\n        ${"left"===l?L:""}\n        <button type="button" role="tab" aria-expanded="false" id="outline-toggle" aria-controls="outline-panel">${t._("OUTLINE")}</button>\n        ${n.Global.showImageOutline?I:""}\n        <button type="button" role="tab" aria-expanded="false" id="settings-toggle" aria-controls="settings-panel">${t._("SETTINGS")}</button>\n        ${"right"===l?L:""}\n      </div>`,_=document.createElement("div");_.setAttribute("id","container"),_.setAttribute("role","region"),_.setAttribute("lang",t._("LANG_CODE")),_.setAttribute("aria-label",t._("CONTAINER_LABEL")),_.setAttribute("dir",n.Global.langDirection),_.innerHTML="top-left"===l||"top-right"===l?`\n        ${y}\n        <div id="panel" class="${l}">\n          ${k}\n          ${f}\n          ${T}\n          ${x}\n          ${w}\n          ${E}\n          ${A}\n          ${v}\n        </div>`:`\n        ${y}\n        <div id="panel" class="${l}">\n          ${v}\n          ${x}\n          ${w}\n          ${E}\n          ${A}\n          ${f}\n          ${k}\n          ${T}\n        </div>`,this.shadowRoot.appendChild(_),n.initializePanelSelectors()}}const M=()=>{n.Panel.outlineToggle.classList.add("active"),n.Panel.outline.classList.add("active"),n.Panel.outlineToggle.setAttribute("aria-expanded","true"),u.setItem("sa11y-remember-outline","Opened"),v(n.Panel.outlineList,n.Panel.outlineContent);o("sa11y-heading-label","root").forEach((e=>e.hidden=!1));const e=new CustomEvent("sa11y-build-heading-outline");document.dispatchEvent(e)},D=()=>{n.Panel.outline.classList.remove("active"),n.Panel.outlineToggle.classList.remove("active"),n.Panel.outlineToggle.setAttribute("aria-expanded","false"),u.setItem("sa11y-remember-outline","Closed");o("sa11y-heading-label","root").forEach((e=>e.hidden=!0))},G=()=>{n.Panel.imagesToggle.classList.add("active"),n.Panel.images.classList.add("active"),n.Panel.imagesToggle.setAttribute("aria-expanded","true"),u.setItem("sa11y-remember-images","Opened"),v(n.Panel.imagesList,n.Panel.imagesContent);const e=new CustomEvent("sa11y-build-image-outline");document.dispatchEvent(e)},B=()=>{n.Global.showImageOutline&&(n.Panel.imagesToggle.classList.remove("active"),n.Panel.images.classList.remove("active"),n.Panel.imagesToggle.setAttribute("aria-expanded","false"),u.setItem("sa11y-remember-images","Closed"))},H=()=>{n.Panel.settingsToggle.classList.add("active"),n.Panel.settings.classList.add("active"),n.Panel.settingsToggle.setAttribute("aria-expanded","true"),u.setItem("sa11y-remember-settings","Opened"),v(n.Panel.settingsContent,n.Panel.settingsContent,t._("SETTINGS"))},F=()=>{n.Panel.settings.classList.remove("active"),n.Panel.settingsToggle.classList.remove("active"),n.Panel.settingsToggle.setAttribute("aria-expanded","false"),u.setItem("sa11y-remember-settings","Closed")};function U(e,i,a){const l=()=>{const d=[];if(e.map((e=>{const t=i.find((t=>e.key.includes(t.dismiss)&&e.href===window.location.pathname));return void 0===t?"":t})).forEach((e=>{Object.assign(e,{dismissedHeading:!0})})),a.showTitleInPageOutline){let e;const n=document.querySelector("head title");if(n&&0!==n.textContent.trim().length){const o=s(n);e=`<li><span class="badge">${t._("TITLE")}</span> ${r(o)}</li>`}else e=`<li><div class="badge error-badge"><span aria-hidden="true"><span class="error-icon"></span></span> ${t._("TITLE")}</div> <div class="badge error-badge">${t._("MISSING")}</div></li>`;d.push(e)}return i.forEach((e=>{const o=e.element,i=e.headingLevel,r=e.text,s=e.index,l=e.type,c=e.hidden,p=e.visibleParent,g=e.dismissedHeading,{isWithinRoot:m}=e;if(!(n.Exclusions.Outline?Array.from(document.querySelectorAll(n.Exclusions.Outline)):[]).includes(o)){const e=!0===c?'<span class="hidden-icon"></span><span class="visually-hidden">Hidden</span>':"",n=!0===c?'class="hidden-h"':"",f=!0===a.showHinPageOutline||1===a.showHinPageOutline?"H":"";let b;"error"===l&&!0===m?(b=`\n        <li class="outline-${i}">\n          <a role="button" id="sa11y-link-${s}" tabindex="-1" ${n}>\n            <span class="badge error-badge">\n            <span aria-hidden="true">${e}\n              <span class="error-icon"></span>\n            </span>\n            <span class="visually-hidden">${t._("ERROR")}</span> ${f+i}</span>\n            <strong class="outline-list-item red-text">${r}</strong>\n          </a>\n        </li>`,d.push(b)):"warning"!==l||g||!0!==m?(b=`\n        <li class="outline-${i}">\n          <a role="button" id="sa11y-link-${s}" tabindex="-1" ${n}>\n            <span class="badge">${e} ${f+i}</span>\n            <span class="outline-list-item">${r}</span>\n          </a>\n        </li>`,d.push(b)):(b=`\n        <li class="outline-${i}">\n          <a role="button" id="sa11y-link-${s}" tabindex="-1" ${n}>\n            <span class="badge warning-badge">\n            <span aria-hidden="true">${e} &#x3f;</span>\n            <span class="visually-hidden">${t._("WARNING")}</span> ${f+i}</span>\n            <strong class="outline-list-item yellow-text">${r}</strong>\n          </a>\n        </li>`,d.push(b));const h=document.createElement("sa11y-heading-label"),y=document.createElement("sa11y-heading-anchor");if(h.hidden=!0,null!==p){o.insertAdjacentElement("beforeend",h);const e=p.previousElementSibling;y.setAttribute("id",`sa11y-h${s}`),e?(e.insertAdjacentElement("beforebegin",y),e.setAttribute("data-sa11y-parent",`h${s}`)):(p.parentNode.insertAdjacentElement("beforebegin",y),p.parentNode.setAttribute("data-sa11y-parent",`h${s}`))}else o.insertAdjacentElement("beforeend",h),h.insertAdjacentElement("beforebegin",y),y.setAttribute("id",`sa11y-h${s}`);const v=document.createElement("span");v.classList.add("heading-label"),v.innerHTML=`H${i}`,h.shadowRoot.appendChild(v),"Opened"===u.getItem("sa11y-remember-outline")&&(h.hidden=!1)}})),n.Panel.outlineList.innerHTML=0===d.length?`<li>${t._("PANEL_NO_HEADINGS")}</li>`:d.join(" "),setTimeout((()=>{const e=document.querySelector("sa11y-control-panel").shadowRoot,i=Array.from(e.querySelectorAll("#outline-list a"));i.forEach(((i,a)=>{const r=e.getElementById(`sa11y-link-${a}`),s=o(`#sa11y-h${a}, [data-sa11y-parent="h${a}"]`,"document",n.Exclusions.Container),l=e=>{("keyup"===e.type&&"Enter"===e.code||"click"===e.type)&&(s.forEach((e=>{(e=>{g(e.parentElement),e.scrollIntoView({behavior:`${n.Global.scrollBehaviour}`,block:"center"})})(e)})),r.classList.contains("hidden-h")?b(`${t._("HEADING_NOT_VISIBLE_ALERT")}`):n.Panel.alert.classList.contains("active")&&f()),e.preventDefault()};r?.addEventListener("click",l,!1),r?.addEventListener("keyup",l,!1)}));let a=0;const r=e=>{if(!["ArrowUp","ArrowDown","Space"].includes(e.code))return;if("Space"===e.code)return void i[a].click();let t;i[a].setAttribute("tabindex",-1),"ArrowDown"===e.code?(t=a+1,a===i.length-1&&(t=0)):"ArrowUp"===e.code&&(t=a-1,0===a&&(t=i.length-1)),i[t].setAttribute("tabindex",0),i[t].focus(),a=t,e.preventDefault()};n.Panel.outlineList.addEventListener("focus",(()=>{i.length>0&&(n.Panel.outlineList.setAttribute("tabindex",-1),i[a].setAttribute("tabindex",0),i[a].focus()),n.Panel.outlineList.addEventListener("keydown",r)})),n.Panel.outlineList.addEventListener("blur",(()=>{n.Panel.outlineList.removeEventListener("keydown",r)}))}),0),document.removeEventListener("sa11y-build-heading-outline",l),e};"Opened"===u.getItem("sa11y-remember-outline")&&l(),document.addEventListener("sa11y-build-heading-outline",l)}function W(e,o){const i=()=>{const r=[];e.map((e=>{const t=o.find((t=>e.key.includes(t.dismiss)&&e.href===window.location.pathname));return void 0===t?"":t})).forEach((e=>{Object.assign(e,{dismissedImage:!0})})),o.forEach((e=>{const o=e.type,{dismissedImage:i}=e,s=a(e.element.alt),{src:l}=e.element,d=e.element.getAttribute("data-src"),c=d&&d.length>3?d:l,p=(e=>{let o;if(0!==n.Global.editImageURLofCMS.length){const{src:a}=e.element,r=n.Global.relativePathImageSRC?n.Global.relativePathImageSRC:window.location.host,s=a.split(r),l=s.length>1?s[1]:"",d=n.Global.relativePathImageID;let c;d.length&&e.element.classList.length&&e.element.classList.forEach((e=>{if(e.startsWith(d)){const[t]=e.match(/\d+/)||[];c=t}}));const p=r&&d.length?n.Global.editImageURLofCMS+c:n.Global.editImageURLofCMS+l;o=((i=a).includes(window.location.host)||i.startsWith(r))&&void 0!==c?`<div class="edit-block"><a\n            href="${encodeURI(p)}"\n            target="_blank"\n            rel="noopener noreferrer"\n            class="edit">${t._("EDIT")}</a></div>`:""}var i;return o??""})(e),u=e.element.closest("a[href]")?`<div class="badge ${o}-badge"><span class="link-icon"></span><span class="visually-hidden">${t._("LINKED")}</span></div>`:"";let g;if("error"===o){const e=0===s.length?`<div class="badge error-badge">${t._("MISSING")}</div>`:`<strong class="red-text">${s}</strong>`;g=`\n        <li class="error">\n          <img src="${c}" alt/>\n          <div class="alt">\n            <div class="badge error-badge"><span class="error-icon"></span><span class="visually-hidden">${t._("ERROR")}</span> ${t._("ALT")}</div> ${u} ${e}\n          </div>\n          ${p}\n        </li>`,r.push(g)}else if("warning"!==o||i){const n=0===s.length?`<div class="badge">${t._("DECORATIVE")}</div>`:"",o=e.element.closest("a[href]")?`<div class="badge"><span class="link-icon"></span><span class="visually-hidden">${t._("LINKED")}</span></div>`:"";g=`\n        <li class="good">\n          <img src="${c}" alt/>\n          <div class="alt">\n            <div class="badge">${t._("ALT")}</div>\n            ${o} ${n} ${s}\n          </div>\n          ${p}\n        </li>`,r.push(g)}else{const e=0===s.length?`<div class="badge warning-badge">${t._("DECORATIVE")}</div>`:"";g=`\n        <li class="warning">\n          <img src="${c}" alt/>\n          <div class="alt">\n            <div class="badge warning-badge"><span aria-hidden="true">&#63;</span> <span class="visually-hidden">${t._("WARNING")}</span> ${t._("ALT")}</div>\n            ${u} ${e} <strong class="yellow-text">${s}</strong>\n          </div>\n          ${p}\n        </li>`,r.push(g)}})),n.Panel.imagesList.innerHTML=0===r.length?`<li>${t._("IMAGES_NOT_FOUND")}</li>`:r.join(" "),document.removeEventListener("sa11y-build-image-outline",i)};"Opened"===u.getItem("sa11y-remember-images")&&i(),document.addEventListener("sa11y-build-image-outline",i)}var j="top",z="bottom",q="right",V="left",Q="auto",K=[j,z,q,V],Y="start",X="end",Z="clippingParents",J="viewport",ee="popper",te="reference",ne=K.reduce((function(e,t){return e.concat([t+"-"+Y,t+"-"+X])}),[]),oe=[].concat(K,[Q]).reduce((function(e,t){return e.concat([t,t+"-"+Y,t+"-"+X])}),[]),ie=["beforeRead","read","afterRead","beforeMain","main","afterMain","beforeWrite","write","afterWrite"];function ae(e){return e?(e.nodeName||"").toLowerCase():null}function re(e){if(null==e)return window;if("[object Window]"!==e.toString()){var t=e.ownerDocument;return t&&t.defaultView||window}return e}function se(e){return e instanceof re(e).Element||e instanceof Element}function le(e){return e instanceof re(e).HTMLElement||e instanceof HTMLElement}function de(e){return"undefined"!=typeof ShadowRoot&&(e instanceof re(e).ShadowRoot||e instanceof ShadowRoot)}var ce={name:"applyStyles",enabled:!0,phase:"write",fn:function(e){var t=e.state;Object.keys(t.elements).forEach((function(e){var n=t.styles[e]||{},o=t.attributes[e]||{},i=t.elements[e];le(i)&&ae(i)&&(Object.assign(i.style,n),Object.keys(o).forEach((function(e){var t=o[e];!1===t?i.removeAttribute(e):i.setAttribute(e,!0===t?"":t)})))}))},effect:function(e){var t=e.state,n={popper:{position:t.options.strategy,left:"0",top:"0",margin:"0"},arrow:{position:"absolute"},reference:{}};return Object.assign(t.elements.popper.style,n.popper),t.styles=n,t.elements.arrow&&Object.assign(t.elements.arrow.style,n.arrow),function(){Object.keys(t.elements).forEach((function(e){var o=t.elements[e],i=t.attributes[e]||{},a=Object.keys(t.styles.hasOwnProperty(e)?t.styles[e]:n[e]).reduce((function(e,t){return e[t]="",e}),{});le(o)&&ae(o)&&(Object.assign(o.style,a),Object.keys(i).forEach((function(e){o.removeAttribute(e)})))}))}},requires:["computeStyles"]};function pe(e){return e.split("-")[0]}var ue=Math.max,ge=Math.min,me=Math.round;function fe(){var e=navigator.userAgentData;return null!=e&&e.brands&&Array.isArray(e.brands)?e.brands.map((function(e){return e.brand+"/"+e.version})).join(" "):navigator.userAgent}function be(){return!/^((?!chrome|android).)*safari/i.test(fe())}function he(e,t,n){void 0===t&&(t=!1),void 0===n&&(n=!1);var o=e.getBoundingClientRect(),i=1,a=1;t&&le(e)&&(i=e.offsetWidth>0&&me(o.width)/e.offsetWidth||1,a=e.offsetHeight>0&&me(o.height)/e.offsetHeight||1);var r=(se(e)?re(e):window).visualViewport,s=!be()&&n,l=(o.left+(s&&r?r.offsetLeft:0))/i,d=(o.top+(s&&r?r.offsetTop:0))/a,c=o.width/i,p=o.height/a;return{width:c,height:p,top:d,right:l+c,bottom:d+p,left:l,x:l,y:d}}function ye(e){var t=he(e),n=e.offsetWidth,o=e.offsetHeight;return Math.abs(t.width-n)<=1&&(n=t.width),Math.abs(t.height-o)<=1&&(o=t.height),{x:e.offsetLeft,y:e.offsetTop,width:n,height:o}}function ve(e,t){var n=t.getRootNode&&t.getRootNode();if(e.contains(t))return!0;if(n&&de(n)){var o=t;do{if(o&&e.isSameNode(o))return!0;o=o.parentNode||o.host}while(o)}return!1}function xe(e){return re(e).getComputedStyle(e)}function we(e){return["table","td","th"].indexOf(ae(e))>=0}function Ee(e){return((se(e)?e.ownerDocument:e.document)||window.document).documentElement}function Ae(e){return"html"===ae(e)?e:e.assignedSlot||e.parentNode||(de(e)?e.host:null)||Ee(e)}function ke(e){return le(e)&&"fixed"!==xe(e).position?e.offsetParent:null}function Ie(e){for(var t=re(e),n=ke(e);n&&we(n)&&"static"===xe(n).position;)n=ke(n);return n&&("html"===ae(n)||"body"===ae(n)&&"static"===xe(n).position)?t:n||function(e){var t=/firefox/i.test(fe());if(/Trident/i.test(fe())&&le(e)&&"fixed"===xe(e).position)return null;var n=Ae(e);for(de(n)&&(n=n.host);le(n)&&["html","body"].indexOf(ae(n))<0;){var o=xe(n);if("none"!==o.transform||"none"!==o.perspective||"paint"===o.contain||-1!==["transform","perspective"].indexOf(o.willChange)||t&&"filter"===o.willChange||t&&o.filter&&"none"!==o.filter)return n;n=n.parentNode}return null}(e)||t}function Le(e){return["top","bottom"].indexOf(e)>=0?"x":"y"}function Te(e,t,n){return ue(e,ge(t,n))}function _e(e){return Object.assign({},{top:0,right:0,bottom:0,left:0},e)}function Se(e,t){return t.reduce((function(t,n){return t[n]=e,t}),{})}var Pe={name:"arrow",enabled:!0,phase:"main",fn:function(e){var t,n=e.state,o=e.name,i=e.options,a=n.elements.arrow,r=n.modifiersData.popperOffsets,s=pe(n.placement),l=Le(s),d=[V,q].indexOf(s)>=0?"height":"width";if(a&&r){var c=function(e,t){return _e("number"!=typeof(e="function"==typeof e?e(Object.assign({},t.rects,{placement:t.placement})):e)?e:Se(e,K))}(i.padding,n),p=ye(a),u="y"===l?j:V,g="y"===l?z:q,m=n.rects.reference[d]+n.rects.reference[l]-r[l]-n.rects.popper[d],f=r[l]-n.rects.reference[l],b=Ie(a),h=b?"y"===l?b.clientHeight||0:b.clientWidth||0:0,y=m/2-f/2,v=c[u],x=h-p[d]-c[g],w=h/2-p[d]/2+y,E=Te(v,w,x),A=l;n.modifiersData[o]=((t={})[A]=E,t.centerOffset=E-w,t)}},effect:function(e){var t=e.state,n=e.options.element,o=void 0===n?"[data-popper-arrow]":n;null!=o&&("string"!=typeof o||(o=t.elements.popper.querySelector(o)))&&ve(t.elements.popper,o)&&(t.elements.arrow=o)},requires:["popperOffsets"],requiresIfExists:["preventOverflow"]};function Ce(e){return e.split("-")[1]}var $e={top:"auto",right:"auto",bottom:"auto",left:"auto"};function Oe(e){var t,n=e.popper,o=e.popperRect,i=e.placement,a=e.variation,r=e.offsets,s=e.position,l=e.gpuAcceleration,d=e.adaptive,c=e.roundOffsets,p=e.isFixed,u=r.x,g=void 0===u?0:u,m=r.y,f=void 0===m?0:m,b="function"==typeof c?c({x:g,y:f}):{x:g,y:f};g=b.x,f=b.y;var h=r.hasOwnProperty("x"),y=r.hasOwnProperty("y"),v=V,x=j,w=window;if(d){var E=Ie(n),A="clientHeight",k="clientWidth";if(E===re(n)&&"static"!==xe(E=Ee(n)).position&&"absolute"===s&&(A="scrollHeight",k="scrollWidth"),i===j||(i===V||i===q)&&a===X)x=z,f-=(p&&E===w&&w.visualViewport?w.visualViewport.height:E[A])-o.height,f*=l?1:-1;if(i===V||(i===j||i===z)&&a===X)v=q,g-=(p&&E===w&&w.visualViewport?w.visualViewport.width:E[k])-o.width,g*=l?1:-1}var I,L=Object.assign({position:s},d&&$e),T=!0===c?function(e,t){var n=e.x,o=e.y,i=t.devicePixelRatio||1;return{x:me(n*i)/i||0,y:me(o*i)/i||0}}({x:g,y:f},re(n)):{x:g,y:f};return g=T.x,f=T.y,l?Object.assign({},L,((I={})[x]=y?"0":"",I[v]=h?"0":"",I.transform=(w.devicePixelRatio||1)<=1?"translate("+g+"px, "+f+"px)":"translate3d("+g+"px, "+f+"px, 0)",I)):Object.assign({},L,((t={})[x]=y?f+"px":"",t[v]=h?g+"px":"",t.transform="",t))}var Ne={passive:!0};var Re={left:"right",right:"left",bottom:"top",top:"bottom"};function Me(e){return e.replace(/left|right|bottom|top/g,(function(e){return Re[e]}))}var De={start:"end",end:"start"};function Ge(e){return e.replace(/start|end/g,(function(e){return De[e]}))}function Be(e){var t=re(e);return{scrollLeft:t.pageXOffset,scrollTop:t.pageYOffset}}function He(e){return he(Ee(e)).left+Be(e).scrollLeft}function Fe(e){var t=xe(e),n=t.overflow,o=t.overflowX,i=t.overflowY;return/auto|scroll|overlay|hidden/.test(n+i+o)}function Ue(e){return["html","body","#document"].indexOf(ae(e))>=0?e.ownerDocument.body:le(e)&&Fe(e)?e:Ue(Ae(e))}function We(e,t){var n;void 0===t&&(t=[]);var o=Ue(e),i=o===(null==(n=e.ownerDocument)?void 0:n.body),a=re(o),r=i?[a].concat(a.visualViewport||[],Fe(o)?o:[]):o,s=t.concat(r);return i?s:s.concat(We(Ae(r)))}function je(e){return Object.assign({},e,{left:e.x,top:e.y,right:e.x+e.width,bottom:e.y+e.height})}function ze(e,t,n){return t===J?je(function(e,t){var n=re(e),o=Ee(e),i=n.visualViewport,a=o.clientWidth,r=o.clientHeight,s=0,l=0;if(i){a=i.width,r=i.height;var d=be();(d||!d&&"fixed"===t)&&(s=i.offsetLeft,l=i.offsetTop)}return{width:a,height:r,x:s+He(e),y:l}}(e,n)):se(t)?function(e,t){var n=he(e,!1,"fixed"===t);return n.top=n.top+e.clientTop,n.left=n.left+e.clientLeft,n.bottom=n.top+e.clientHeight,n.right=n.left+e.clientWidth,n.width=e.clientWidth,n.height=e.clientHeight,n.x=n.left,n.y=n.top,n}(t,n):je(function(e){var t,n=Ee(e),o=Be(e),i=null==(t=e.ownerDocument)?void 0:t.body,a=ue(n.scrollWidth,n.clientWidth,i?i.scrollWidth:0,i?i.clientWidth:0),r=ue(n.scrollHeight,n.clientHeight,i?i.scrollHeight:0,i?i.clientHeight:0),s=-o.scrollLeft+He(e),l=-o.scrollTop;return"rtl"===xe(i||n).direction&&(s+=ue(n.clientWidth,i?i.clientWidth:0)-a),{width:a,height:r,x:s,y:l}}(Ee(e)))}function qe(e,t,n,o){var i="clippingParents"===t?function(e){var t=We(Ae(e)),n=["absolute","fixed"].indexOf(xe(e).position)>=0&&le(e)?Ie(e):e;return se(n)?t.filter((function(e){return se(e)&&ve(e,n)&&"body"!==ae(e)})):[]}(e):[].concat(t),a=[].concat(i,[n]),r=a[0],s=a.reduce((function(t,n){var i=ze(e,n,o);return t.top=ue(i.top,t.top),t.right=ge(i.right,t.right),t.bottom=ge(i.bottom,t.bottom),t.left=ue(i.left,t.left),t}),ze(e,r,o));return s.width=s.right-s.left,s.height=s.bottom-s.top,s.x=s.left,s.y=s.top,s}function Ve(e){var t,n=e.reference,o=e.element,i=e.placement,a=i?pe(i):null,r=i?Ce(i):null,s=n.x+n.width/2-o.width/2,l=n.y+n.height/2-o.height/2;switch(a){case j:t={x:s,y:n.y-o.height};break;case z:t={x:s,y:n.y+n.height};break;case q:t={x:n.x+n.width,y:l};break;case V:t={x:n.x-o.width,y:l};break;default:t={x:n.x,y:n.y}}var d=a?Le(a):null;if(null!=d){var c="y"===d?"height":"width";switch(r){case Y:t[d]=t[d]-(n[c]/2-o[c]/2);break;case X:t[d]=t[d]+(n[c]/2-o[c]/2)}}return t}function Qe(e,t){void 0===t&&(t={});var n=t,o=n.placement,i=void 0===o?e.placement:o,a=n.strategy,r=void 0===a?e.strategy:a,s=n.boundary,l=void 0===s?Z:s,d=n.rootBoundary,c=void 0===d?J:d,p=n.elementContext,u=void 0===p?ee:p,g=n.altBoundary,m=void 0!==g&&g,f=n.padding,b=void 0===f?0:f,h=_e("number"!=typeof b?b:Se(b,K)),y=u===ee?te:ee,v=e.rects.popper,x=e.elements[m?y:u],w=qe(se(x)?x:x.contextElement||Ee(e.elements.popper),l,c,r),E=he(e.elements.reference),A=Ve({reference:E,element:v,strategy:"absolute",placement:i}),k=je(Object.assign({},v,A)),I=u===ee?k:E,L={top:w.top-I.top+h.top,bottom:I.bottom-w.bottom+h.bottom,left:w.left-I.left+h.left,right:I.right-w.right+h.right},T=e.modifiersData.offset;if(u===ee&&T){var _=T[i];Object.keys(L).forEach((function(e){var t=[q,z].indexOf(e)>=0?1:-1,n=[j,z].indexOf(e)>=0?"y":"x";L[e]+=_[n]*t}))}return L}function Ke(e,t){void 0===t&&(t={});var n=t,o=n.placement,i=n.boundary,a=n.rootBoundary,r=n.padding,s=n.flipVariations,l=n.allowedAutoPlacements,d=void 0===l?oe:l,c=Ce(o),p=c?s?ne:ne.filter((function(e){return Ce(e)===c})):K,u=p.filter((function(e){return d.indexOf(e)>=0}));0===u.length&&(u=p);var g=u.reduce((function(t,n){return t[n]=Qe(e,{placement:n,boundary:i,rootBoundary:a,padding:r})[pe(n)],t}),{});return Object.keys(g).sort((function(e,t){return g[e]-g[t]}))}var Ye={name:"flip",enabled:!0,phase:"main",fn:function(e){var t=e.state,n=e.options,o=e.name;if(!t.modifiersData[o]._skip){for(var i=n.mainAxis,a=void 0===i||i,r=n.altAxis,s=void 0===r||r,l=n.fallbackPlacements,d=n.padding,c=n.boundary,p=n.rootBoundary,u=n.altBoundary,g=n.flipVariations,m=void 0===g||g,f=n.allowedAutoPlacements,b=t.options.placement,h=pe(b),y=l||(h===b||!m?[Me(b)]:function(e){if(pe(e)===Q)return[];var t=Me(e);return[Ge(e),t,Ge(t)]}(b)),v=[b].concat(y).reduce((function(e,n){return e.concat(pe(n)===Q?Ke(t,{placement:n,boundary:c,rootBoundary:p,padding:d,flipVariations:m,allowedAutoPlacements:f}):n)}),[]),x=t.rects.reference,w=t.rects.popper,E=new Map,A=!0,k=v[0],I=0;I<v.length;I++){var L=v[I],T=pe(L),_=Ce(L)===Y,S=[j,z].indexOf(T)>=0,P=S?"width":"height",C=Qe(t,{placement:L,boundary:c,rootBoundary:p,altBoundary:u,padding:d}),$=S?_?q:V:_?z:j;x[P]>w[P]&&($=Me($));var O=Me($),N=[];if(a&&N.push(C[T]<=0),s&&N.push(C[$]<=0,C[O]<=0),N.every((function(e){return e}))){k=L,A=!1;break}E.set(L,N)}if(A)for(var R=function(e){var t=v.find((function(t){var n=E.get(t);if(n)return n.slice(0,e).every((function(e){return e}))}));if(t)return k=t,"break"},M=m?3:1;M>0;M--){if("break"===R(M))break}t.placement!==k&&(t.modifiersData[o]._skip=!0,t.placement=k,t.reset=!0)}},requiresIfExists:["offset"],data:{_skip:!1}};function Xe(e,t,n){return void 0===n&&(n={x:0,y:0}),{top:e.top-t.height-n.y,right:e.right-t.width+n.x,bottom:e.bottom-t.height+n.y,left:e.left-t.width-n.x}}function Ze(e){return[j,q,z,V].some((function(t){return e[t]>=0}))}var Je={name:"offset",enabled:!0,phase:"main",requires:["popperOffsets"],fn:function(e){var t=e.state,n=e.options,o=e.name,i=n.offset,a=void 0===i?[0,0]:i,r=oe.reduce((function(e,n){return e[n]=function(e,t,n){var o=pe(e),i=[V,j].indexOf(o)>=0?-1:1,a="function"==typeof n?n(Object.assign({},t,{placement:e})):n,r=a[0],s=a[1];return r=r||0,s=(s||0)*i,[V,q].indexOf(o)>=0?{x:s,y:r}:{x:r,y:s}}(n,t.rects,a),e}),{}),s=r[t.placement],l=s.x,d=s.y;null!=t.modifiersData.popperOffsets&&(t.modifiersData.popperOffsets.x+=l,t.modifiersData.popperOffsets.y+=d),t.modifiersData[o]=r}};var et={name:"preventOverflow",enabled:!0,phase:"main",fn:function(e){var t=e.state,n=e.options,o=e.name,i=n.mainAxis,a=void 0===i||i,r=n.altAxis,s=void 0!==r&&r,l=n.boundary,d=n.rootBoundary,c=n.altBoundary,p=n.padding,u=n.tether,g=void 0===u||u,m=n.tetherOffset,f=void 0===m?0:m,b=Qe(t,{boundary:l,rootBoundary:d,padding:p,altBoundary:c}),h=pe(t.placement),y=Ce(t.placement),v=!y,x=Le(h),w="x"===x?"y":"x",E=t.modifiersData.popperOffsets,A=t.rects.reference,k=t.rects.popper,I="function"==typeof f?f(Object.assign({},t.rects,{placement:t.placement})):f,L="number"==typeof I?{mainAxis:I,altAxis:I}:Object.assign({mainAxis:0,altAxis:0},I),T=t.modifiersData.offset?t.modifiersData.offset[t.placement]:null,_={x:0,y:0};if(E){if(a){var S,P="y"===x?j:V,C="y"===x?z:q,$="y"===x?"height":"width",O=E[x],N=O+b[P],R=O-b[C],M=g?-k[$]/2:0,D=y===Y?A[$]:k[$],G=y===Y?-k[$]:-A[$],B=t.elements.arrow,H=g&&B?ye(B):{width:0,height:0},F=t.modifiersData["arrow#persistent"]?t.modifiersData["arrow#persistent"].padding:{top:0,right:0,bottom:0,left:0},U=F[P],W=F[C],Q=Te(0,A[$],H[$]),K=v?A[$]/2-M-Q-U-L.mainAxis:D-Q-U-L.mainAxis,X=v?-A[$]/2+M+Q+W+L.mainAxis:G+Q+W+L.mainAxis,Z=t.elements.arrow&&Ie(t.elements.arrow),J=Z?"y"===x?Z.clientTop||0:Z.clientLeft||0:0,ee=null!=(S=null==T?void 0:T[x])?S:0,te=O+X-ee,ne=Te(g?ge(N,O+K-ee-J):N,O,g?ue(R,te):R);E[x]=ne,_[x]=ne-O}if(s){var oe,ie="x"===x?j:V,ae="x"===x?z:q,re=E[w],se="y"===w?"height":"width",le=re+b[ie],de=re-b[ae],ce=-1!==[j,V].indexOf(h),me=null!=(oe=null==T?void 0:T[w])?oe:0,fe=ce?le:re-A[se]-k[se]-me+L.altAxis,be=ce?re+A[se]+k[se]-me-L.altAxis:de,he=g&&ce?function(e,t,n){var o=Te(e,t,n);return o>n?n:o}(fe,re,be):Te(g?fe:le,re,g?be:de);E[w]=he,_[w]=he-re}t.modifiersData[o]=_}},requiresIfExists:["offset"]};function tt(e,t,n){void 0===n&&(n=!1);var o,i,a=le(t),r=le(t)&&function(e){var t=e.getBoundingClientRect(),n=me(t.width)/e.offsetWidth||1,o=me(t.height)/e.offsetHeight||1;return 1!==n||1!==o}(t),s=Ee(t),l=he(e,r,n),d={scrollLeft:0,scrollTop:0},c={x:0,y:0};return(a||!a&&!n)&&(("body"!==ae(t)||Fe(s))&&(d=(o=t)!==re(o)&&le(o)?{scrollLeft:(i=o).scrollLeft,scrollTop:i.scrollTop}:Be(o)),le(t)?((c=he(t,!0)).x+=t.clientLeft,c.y+=t.clientTop):s&&(c.x=He(s))),{x:l.left+d.scrollLeft-c.x,y:l.top+d.scrollTop-c.y,width:l.width,height:l.height}}function nt(e){var t=new Map,n=new Set,o=[];function i(e){n.add(e.name),[].concat(e.requires||[],e.requiresIfExists||[]).forEach((function(e){if(!n.has(e)){var o=t.get(e);o&&i(o)}})),o.push(e)}return e.forEach((function(e){t.set(e.name,e)})),e.forEach((function(e){n.has(e.name)||i(e)})),o}var ot={placement:"bottom",modifiers:[],strategy:"absolute"};function it(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return!t.some((function(e){return!(e&&"function"==typeof e.getBoundingClientRect)}))}function at(e){void 0===e&&(e={});var t=e,n=t.defaultModifiers,o=void 0===n?[]:n,i=t.defaultOptions,a=void 0===i?ot:i;return function(e,t,n){void 0===n&&(n=a);var i,r,s={placement:"bottom",orderedModifiers:[],options:Object.assign({},ot,a),modifiersData:{},elements:{reference:e,popper:t},attributes:{},styles:{}},l=[],d=!1,c={state:s,setOptions:function(n){var i="function"==typeof n?n(s.options):n;p(),s.options=Object.assign({},a,s.options,i),s.scrollParents={reference:se(e)?We(e):e.contextElement?We(e.contextElement):[],popper:We(t)};var r,d,u=function(e){var t=nt(e);return ie.reduce((function(e,n){return e.concat(t.filter((function(e){return e.phase===n})))}),[])}((r=[].concat(o,s.options.modifiers),d=r.reduce((function(e,t){var n=e[t.name];return e[t.name]=n?Object.assign({},n,t,{options:Object.assign({},n.options,t.options),data:Object.assign({},n.data,t.data)}):t,e}),{}),Object.keys(d).map((function(e){return d[e]}))));return s.orderedModifiers=u.filter((function(e){return e.enabled})),s.orderedModifiers.forEach((function(e){var t=e.name,n=e.options,o=void 0===n?{}:n,i=e.effect;if("function"==typeof i){var a=i({state:s,name:t,instance:c,options:o}),r=function(){};l.push(a||r)}})),c.update()},forceUpdate:function(){if(!d){var e=s.elements,t=e.reference,n=e.popper;if(it(t,n)){s.rects={reference:tt(t,Ie(n),"fixed"===s.options.strategy),popper:ye(n)},s.reset=!1,s.placement=s.options.placement,s.orderedModifiers.forEach((function(e){return s.modifiersData[e.name]=Object.assign({},e.data)}));for(var o=0;o<s.orderedModifiers.length;o++)if(!0!==s.reset){var i=s.orderedModifiers[o],a=i.fn,r=i.options,l=void 0===r?{}:r,p=i.name;"function"==typeof a&&(s=a({state:s,options:l,name:p,instance:c})||s)}else s.reset=!1,o=-1}}},update:(i=function(){return new Promise((function(e){c.forceUpdate(),e(s)}))},function(){return r||(r=new Promise((function(e){Promise.resolve().then((function(){r=void 0,e(i())}))}))),r}),destroy:function(){p(),d=!0}};if(!it(e,t))return c;function p(){l.forEach((function(e){return e()})),l=[]}return c.setOptions(n).then((function(e){!d&&n.onFirstUpdate&&n.onFirstUpdate(e)})),c}}var rt=at({defaultModifiers:[{name:"eventListeners",enabled:!0,phase:"write",fn:function(){},effect:function(e){var t=e.state,n=e.instance,o=e.options,i=o.scroll,a=void 0===i||i,r=o.resize,s=void 0===r||r,l=re(t.elements.popper),d=[].concat(t.scrollParents.reference,t.scrollParents.popper);return a&&d.forEach((function(e){e.addEventListener("scroll",n.update,Ne)})),s&&l.addEventListener("resize",n.update,Ne),function(){a&&d.forEach((function(e){e.removeEventListener("scroll",n.update,Ne)})),s&&l.removeEventListener("resize",n.update,Ne)}},data:{}},{name:"popperOffsets",enabled:!0,phase:"read",fn:function(e){var t=e.state,n=e.name;t.modifiersData[n]=Ve({reference:t.rects.reference,element:t.rects.popper,strategy:"absolute",placement:t.placement})},data:{}},{name:"computeStyles",enabled:!0,phase:"beforeWrite",fn:function(e){var t=e.state,n=e.options,o=n.gpuAcceleration,i=void 0===o||o,a=n.adaptive,r=void 0===a||a,s=n.roundOffsets,l=void 0===s||s,d={placement:pe(t.placement),variation:Ce(t.placement),popper:t.elements.popper,popperRect:t.rects.popper,gpuAcceleration:i,isFixed:"fixed"===t.options.strategy};null!=t.modifiersData.popperOffsets&&(t.styles.popper=Object.assign({},t.styles.popper,Oe(Object.assign({},d,{offsets:t.modifiersData.popperOffsets,position:t.options.strategy,adaptive:r,roundOffsets:l})))),null!=t.modifiersData.arrow&&(t.styles.arrow=Object.assign({},t.styles.arrow,Oe(Object.assign({},d,{offsets:t.modifiersData.arrow,position:"absolute",adaptive:!1,roundOffsets:l})))),t.attributes.popper=Object.assign({},t.attributes.popper,{"data-popper-placement":t.placement})},data:{}},ce,Je,Ye,et,Pe,{name:"hide",enabled:!0,phase:"main",requiresIfExists:["preventOverflow"],fn:function(e){var t=e.state,n=e.name,o=t.rects.reference,i=t.rects.popper,a=t.modifiersData.preventOverflow,r=Qe(t,{elementContext:"reference"}),s=Qe(t,{altBoundary:!0}),l=Xe(r,o),d=Xe(s,i,a),c=Ze(l),p=Ze(d);t.modifiersData[n]={referenceClippingOffsets:l,popperEscapeOffsets:d,isReferenceHidden:c,hasPopperEscaped:p},t.attributes.popper=Object.assign({},t.attributes.popper,{"data-popper-reference-hidden":c,"data-popper-escaped":p})}}]}),st="tippy-content",lt="tippy-backdrop",dt="tippy-arrow",ct="tippy-svg-arrow",pt={passive:!0,capture:!0},ut=function(){return document.body};function gt(e,t,n){if(Array.isArray(e)){var o=e[t];return null==o?Array.isArray(n)?n[t]:n:o}return e}function mt(e,t){var n={}.toString.call(e);return 0===n.indexOf("[object")&&n.indexOf(t+"]")>-1}function ft(e,t){return"function"==typeof e?e.apply(void 0,t):e}function bt(e,t){return 0===t?e:function(o){clearTimeout(n),n=setTimeout((function(){e(o)}),t)};var n}function ht(e){return[].concat(e)}function yt(e,t){-1===e.indexOf(t)&&e.push(t)}function vt(e){return[].slice.call(e)}function xt(e){return Object.keys(e).reduce((function(t,n){return void 0!==e[n]&&(t[n]=e[n]),t}),{})}function wt(){return document.createElement("div")}function Et(e){return["Element","Fragment"].some((function(t){return mt(e,t)}))}function At(e){return Et(e)?[e]:function(e){return mt(e,"NodeList")}(e)?vt(e):Array.isArray(e)?e:vt(document.querySelectorAll(e))}function kt(e,t){e.forEach((function(e){e&&(e.style.transitionDuration=t+"ms")}))}function It(e,t){e.forEach((function(e){e&&e.setAttribute("data-state",t)}))}function Lt(e,t,n){var o=t+"EventListener";["transitionend","webkitTransitionEnd"].forEach((function(t){e[o](t,n)}))}function Tt(e,t){for(var n=t;n;){var o;if(e.contains(n))return!0;n=null==n.getRootNode||null==(o=n.getRootNode())?void 0:o.host}return!1}var _t={isTouch:!1},St=0;function Pt(){_t.isTouch||(_t.isTouch=!0,window.performance&&document.addEventListener("mousemove",Ct))}function Ct(){var e=performance.now();e-St<20&&(_t.isTouch=!1,document.removeEventListener("mousemove",Ct)),St=e}function $t(){var e,t=document.activeElement;if((e=t)&&e._tippy&&e._tippy.reference===e){var n=t._tippy;t.blur&&!n.state.isVisible&&t.blur()}}var Ot=!!("undefined"!=typeof window&&"undefined"!=typeof document)&&!!window.msCrypto,Nt=Object.assign({appendTo:ut,aria:{content:"auto",expanded:"auto"},delay:0,duration:[300,250],getReferenceClientRect:null,hideOnClick:!0,ignoreAttributes:!1,interactive:!1,interactiveBorder:2,interactiveDebounce:0,moveTransition:"",offset:[0,10],onAfterUpdate:function(){},onBeforeUpdate:function(){},onCreate:function(){},onDestroy:function(){},onHidden:function(){},onHide:function(){},onMount:function(){},onShow:function(){},onShown:function(){},onTrigger:function(){},onUntrigger:function(){},onClickOutside:function(){},placement:"top",plugins:[],popperOptions:{},render:null,showOnCreate:!1,touch:!0,trigger:"mouseenter focus",triggerTarget:null},{animateFill:!1,followCursor:!1,inlinePositioning:!1,sticky:!1},{allowHTML:!1,animation:"fade",arrow:!0,content:"",inertia:!1,maxWidth:350,role:"tooltip",theme:"",zIndex:9999}),Rt=Object.keys(Nt);function Mt(e){var t=(e.plugins||[]).reduce((function(t,n){var o,i=n.name,a=n.defaultValue;i&&(t[i]=void 0!==e[i]?e[i]:null!=(o=Nt[i])?o:a);return t}),{});return Object.assign({},e,t)}function Dt(e,t){var n=Object.assign({},t,{content:ft(t.content,[e])},t.ignoreAttributes?{}:function(e,t){return(t?Object.keys(Mt(Object.assign({},Nt,{plugins:t}))):Rt).reduce((function(t,n){var o=(e.getAttribute("data-tippy-"+n)||"").trim();if(!o)return t;if("content"===n)t[n]=o;else try{t[n]=JSON.parse(o)}catch(e){t[n]=o}return t}),{})}(e,t.plugins));return n.aria=Object.assign({},Nt.aria,n.aria),n.aria={expanded:"auto"===n.aria.expanded?t.interactive:n.aria.expanded,content:"auto"===n.aria.content?t.interactive?null:"describedby":n.aria.content},n}var Gt=function(){return"innerHTML"};function Bt(e,t){e[Gt()]=t}function Ht(e){var t=wt();return!0===e?t.className=dt:(t.className=ct,Et(e)?t.appendChild(e):Bt(t,e)),t}function Ft(e,t){Et(t.content)?(Bt(e,""),e.appendChild(t.content)):"function"!=typeof t.content&&(t.allowHTML?Bt(e,t.content):e.textContent=t.content)}function Ut(e){var t=e.firstElementChild,n=vt(t.children);return{box:t,content:n.find((function(e){return e.classList.contains(st)})),arrow:n.find((function(e){return e.classList.contains(dt)||e.classList.contains(ct)})),backdrop:n.find((function(e){return e.classList.contains(lt)}))}}function Wt(e){var t=wt(),n=wt();n.className="tippy-box",n.setAttribute("data-state","hidden"),n.setAttribute("tabindex","-1");var o=wt();function i(n,o){var i=Ut(t),a=i.box,r=i.content,s=i.arrow;o.theme?a.setAttribute("data-theme",o.theme):a.removeAttribute("data-theme"),"string"==typeof o.animation?a.setAttribute("data-animation",o.animation):a.removeAttribute("data-animation"),o.inertia?a.setAttribute("data-inertia",""):a.removeAttribute("data-inertia"),a.style.maxWidth="number"==typeof o.maxWidth?o.maxWidth+"px":o.maxWidth,o.role?a.setAttribute("role",o.role):a.removeAttribute("role"),n.content===o.content&&n.allowHTML===o.allowHTML||Ft(r,e.props),o.arrow?s?n.arrow!==o.arrow&&(a.removeChild(s),a.appendChild(Ht(o.arrow))):a.appendChild(Ht(o.arrow)):s&&a.removeChild(s)}return o.className=st,o.setAttribute("data-state","hidden"),Ft(o,e.props),t.appendChild(n),n.appendChild(o),i(e.props,e.props),{popper:t,onUpdate:i}}Wt.$$tippy=!0;var jt=1,zt=[],qt=[];function Vt(e,t){var n,o,i,a,r,s,l,d,c=Dt(e,Object.assign({},Nt,Mt(xt(t)))),p=!1,u=!1,g=!1,m=!1,f=[],b=bt(V,c.interactiveDebounce),h=jt++,y=(d=c.plugins).filter((function(e,t){return d.indexOf(e)===t})),v={id:h,reference:e,popper:wt(),popperInstance:null,props:c,state:{isEnabled:!0,isVisible:!1,isDestroyed:!1,isMounted:!1,isShown:!1},plugins:y,clearDelayTimeouts:function(){clearTimeout(n),clearTimeout(o),cancelAnimationFrame(i)},setProps:function(t){if(v.state.isDestroyed)return;O("onBeforeUpdate",[v,t]),z();var n=v.props,o=Dt(e,Object.assign({},n,xt(t),{ignoreAttributes:!0}));v.props=o,j(),n.interactiveDebounce!==o.interactiveDebounce&&(M(),b=bt(V,o.interactiveDebounce));n.triggerTarget&&!o.triggerTarget?ht(n.triggerTarget).forEach((function(e){e.removeAttribute("aria-expanded")})):o.triggerTarget&&e.removeAttribute("aria-expanded");R(),$(),E&&E(n,o);v.popperInstance&&(X(),J().forEach((function(e){requestAnimationFrame(e._tippy.popperInstance.forceUpdate)})));O("onAfterUpdate",[v,t])},setContent:function(e){v.setProps({content:e})},show:function(){var e=v.state.isVisible,t=v.state.isDestroyed,n=!v.state.isEnabled,o=_t.isTouch&&!v.props.touch,i=gt(v.props.duration,0,Nt.duration);if(e||t||n||o)return;if(_().hasAttribute("disabled"))return;if(O("onShow",[v],!1),!1===v.props.onShow(v))return;v.state.isVisible=!0,T()&&(w.style.visibility="visible");$(),H(),v.state.isMounted||(w.style.transition="none");if(T()){var a=P();kt([a.box,a.content],0)}s=function(){var e;if(v.state.isVisible&&!m){if(m=!0,w.offsetHeight,w.style.transition=v.props.moveTransition,T()&&v.props.animation){var t=P(),n=t.box,o=t.content;kt([n,o],i),It([n,o],"visible")}N(),R(),yt(qt,v),null==(e=v.popperInstance)||e.forceUpdate(),O("onMount",[v]),v.props.animation&&T()&&function(e,t){U(e,t)}(i,(function(){v.state.isShown=!0,O("onShown",[v])}))}},function(){var e,t=v.props.appendTo,n=_();e=v.props.interactive&&t===ut||"parent"===t?n.parentNode:ft(t,[n]);e.contains(w)||e.appendChild(w);v.state.isMounted=!0,X()}()},hide:function(){var e=!v.state.isVisible,t=v.state.isDestroyed,n=!v.state.isEnabled,o=gt(v.props.duration,1,Nt.duration);if(e||t||n)return;if(O("onHide",[v],!1),!1===v.props.onHide(v))return;v.state.isVisible=!1,v.state.isShown=!1,m=!1,p=!1,T()&&(w.style.visibility="hidden");if(M(),F(),$(!0),T()){var i=P(),a=i.box,r=i.content;v.props.animation&&(kt([a,r],o),It([a,r],"hidden"))}N(),R(),v.props.animation?T()&&function(e,t){U(e,(function(){!v.state.isVisible&&w.parentNode&&w.parentNode.contains(w)&&t()}))}(o,v.unmount):v.unmount()},hideWithInteractivity:function(e){S().addEventListener("mousemove",b),yt(zt,b),b(e)},enable:function(){v.state.isEnabled=!0},disable:function(){v.hide(),v.state.isEnabled=!1},unmount:function(){v.state.isVisible&&v.hide();if(!v.state.isMounted)return;Z(),J().forEach((function(e){e._tippy.unmount()})),w.parentNode&&w.parentNode.removeChild(w);qt=qt.filter((function(e){return e!==v})),v.state.isMounted=!1,O("onHidden",[v])},destroy:function(){if(v.state.isDestroyed)return;v.clearDelayTimeouts(),v.unmount(),z(),delete e._tippy,v.state.isDestroyed=!0,O("onDestroy",[v])}};if(!c.render)return v;var x=c.render(v),w=x.popper,E=x.onUpdate;w.setAttribute("data-tippy-root",""),w.id="tippy-"+v.id,v.popper=w,e._tippy=v,w._tippy=v;var A=y.map((function(e){return e.fn(v)})),k=e.hasAttribute("aria-expanded");return j(),R(),$(),O("onCreate",[v]),c.showOnCreate&&ee(),w.addEventListener("mouseenter",(function(){v.props.interactive&&v.state.isVisible&&v.clearDelayTimeouts()})),w.addEventListener("mouseleave",(function(){v.props.interactive&&v.props.trigger.indexOf("mouseenter")>=0&&S().addEventListener("mousemove",b)})),v;function I(){var e=v.props.touch;return Array.isArray(e)?e:[e,0]}function L(){return"hold"===I()[0]}function T(){var e;return!(null==(e=v.props.render)||!e.$$tippy)}function _(){return l||e}function S(){var e,t,n=_().parentNode;return n?null!=(t=ht(n)[0])&&null!=(e=t.ownerDocument)&&e.body?t.ownerDocument:document:document}function P(){return Ut(w)}function C(e){return v.state.isMounted&&!v.state.isVisible||_t.isTouch||a&&"focus"===a.type?0:gt(v.props.delay,e?0:1,Nt.delay)}function $(e){void 0===e&&(e=!1),w.style.pointerEvents=v.props.interactive&&!e?"":"none",w.style.zIndex=""+v.props.zIndex}function O(e,t,n){var o;(void 0===n&&(n=!0),A.forEach((function(n){n[e]&&n[e].apply(n,t)})),n)&&(o=v.props)[e].apply(o,t)}function N(){var t=v.props.aria;if(t.content){var n="aria-"+t.content,o=w.id;ht(v.props.triggerTarget||e).forEach((function(e){var t=e.getAttribute(n);if(v.state.isVisible)e.setAttribute(n,t?t+" "+o:o);else{var i=t&&t.replace(o,"").trim();i?e.setAttribute(n,i):e.removeAttribute(n)}}))}}function R(){!k&&v.props.aria.expanded&&ht(v.props.triggerTarget||e).forEach((function(e){v.props.interactive?e.setAttribute("aria-expanded",v.state.isVisible&&e===_()?"true":"false"):e.removeAttribute("aria-expanded")}))}function M(){S().removeEventListener("mousemove",b),zt=zt.filter((function(e){return e!==b}))}function D(t){if(!_t.isTouch||!g&&"mousedown"!==t.type){var n=t.composedPath&&t.composedPath()[0]||t.target;if(!v.props.interactive||!Tt(w,n)){if(ht(v.props.triggerTarget||e).some((function(e){return Tt(e,n)}))){if(_t.isTouch)return;if(v.state.isVisible&&v.props.trigger.indexOf("click")>=0)return}else O("onClickOutside",[v,t]);!0===v.props.hideOnClick&&(v.clearDelayTimeouts(),v.hide(),u=!0,setTimeout((function(){u=!1})),v.state.isMounted||F())}}}function G(){g=!0}function B(){g=!1}function H(){var e=S();e.addEventListener("mousedown",D,!0),e.addEventListener("touchend",D,pt),e.addEventListener("touchstart",B,pt),e.addEventListener("touchmove",G,pt)}function F(){var e=S();e.removeEventListener("mousedown",D,!0),e.removeEventListener("touchend",D,pt),e.removeEventListener("touchstart",B,pt),e.removeEventListener("touchmove",G,pt)}function U(e,t){var n=P().box;function o(e){e.target===n&&(Lt(n,"remove",o),t())}if(0===e)return t();Lt(n,"remove",r),Lt(n,"add",o),r=o}function W(t,n,o){void 0===o&&(o=!1),ht(v.props.triggerTarget||e).forEach((function(e){e.addEventListener(t,n,o),f.push({node:e,eventType:t,handler:n,options:o})}))}function j(){var e;L()&&(W("touchstart",q,{passive:!0}),W("touchend",Q,{passive:!0})),(e=v.props.trigger,e.split(/\s+/).filter(Boolean)).forEach((function(e){if("manual"!==e)switch(W(e,q),e){case"mouseenter":W("mouseleave",Q);break;case"focus":W(Ot?"focusout":"blur",K);break;case"focusin":W("focusout",K)}}))}function z(){f.forEach((function(e){var t=e.node,n=e.eventType,o=e.handler,i=e.options;t.removeEventListener(n,o,i)})),f=[]}function q(e){var t,n=!1;if(v.state.isEnabled&&!Y(e)&&!u){var o="focus"===(null==(t=a)?void 0:t.type);a=e,l=e.currentTarget,R(),!v.state.isVisible&&mt(e,"MouseEvent")&&zt.forEach((function(t){return t(e)})),"click"===e.type&&(v.props.trigger.indexOf("mouseenter")<0||p)&&!1!==v.props.hideOnClick&&v.state.isVisible?n=!0:ee(e),"click"===e.type&&(p=!n),n&&!o&&te(e)}}function V(e){var t=e.target,n=_().contains(t)||w.contains(t);if("mousemove"!==e.type||!n){var o=J().concat(w).map((function(e){var t,n=null==(t=e._tippy.popperInstance)?void 0:t.state;return n?{popperRect:e.getBoundingClientRect(),popperState:n,props:c}:null})).filter(Boolean);(function(e,t){var n=t.clientX,o=t.clientY;return e.every((function(e){var t=e.popperRect,i=e.popperState,a=e.props.interactiveBorder,r=i.placement.split("-")[0],s=i.modifiersData.offset;if(!s)return!0;var l="bottom"===r?s.top.y:0,d="top"===r?s.bottom.y:0,c="right"===r?s.left.x:0,p="left"===r?s.right.x:0,u=t.top-o+l>a,g=o-t.bottom-d>a,m=t.left-n+c>a,f=n-t.right-p>a;return u||g||m||f}))})(o,e)&&(M(),te(e))}}function Q(e){Y(e)||v.props.trigger.indexOf("click")>=0&&p||(v.props.interactive?v.hideWithInteractivity(e):te(e))}function K(e){v.props.trigger.indexOf("focusin")<0&&e.target!==_()||v.props.interactive&&e.relatedTarget&&w.contains(e.relatedTarget)||te(e)}function Y(e){return!!_t.isTouch&&L()!==e.type.indexOf("touch")>=0}function X(){Z();var t=v.props,n=t.popperOptions,o=t.placement,i=t.offset,a=t.getReferenceClientRect,r=t.moveTransition,l=T()?Ut(w).arrow:null,d=a?{getBoundingClientRect:a,contextElement:a.contextElement||_()}:e,c={name:"$$tippy",enabled:!0,phase:"beforeWrite",requires:["computeStyles"],fn:function(e){var t=e.state;if(T()){var n=P().box;["placement","reference-hidden","escaped"].forEach((function(e){"placement"===e?n.setAttribute("data-placement",t.placement):t.attributes.popper["data-popper-"+e]?n.setAttribute("data-"+e,""):n.removeAttribute("data-"+e)})),t.attributes.popper={}}}},p=[{name:"offset",options:{offset:i}},{name:"preventOverflow",options:{padding:{top:2,bottom:2,left:5,right:5}}},{name:"flip",options:{padding:5}},{name:"computeStyles",options:{adaptive:!r}},c];T()&&l&&p.push({name:"arrow",options:{element:l,padding:3}}),p.push.apply(p,(null==n?void 0:n.modifiers)||[]),v.popperInstance=rt(d,w,Object.assign({},n,{placement:o,onFirstUpdate:s,modifiers:p}))}function Z(){v.popperInstance&&(v.popperInstance.destroy(),v.popperInstance=null)}function J(){return vt(w.querySelectorAll("[data-tippy-root]"))}function ee(e){v.clearDelayTimeouts(),e&&O("onTrigger",[v,e]),H();var t=C(!0),o=I(),i=o[0],a=o[1];_t.isTouch&&"hold"===i&&a&&(t=a),t?n=setTimeout((function(){v.show()}),t):v.show()}function te(e){if(v.clearDelayTimeouts(),O("onUntrigger",[v,e]),v.state.isVisible){if(!(v.props.trigger.indexOf("mouseenter")>=0&&v.props.trigger.indexOf("click")>=0&&["mouseleave","mousemove"].indexOf(e.type)>=0&&p)){var t=C(!1);t?o=setTimeout((function(){v.state.isVisible&&v.hide()}),t):i=requestAnimationFrame((function(){v.hide()}))}}else F()}}function Qt(e,t){void 0===t&&(t={});var n=Nt.plugins.concat(t.plugins||[]);document.addEventListener("touchstart",Pt,pt),window.addEventListener("blur",$t);var o=Object.assign({},t,{plugins:n}),i=At(e).reduce((function(e,t){var n=t&&Vt(t,o);return n&&e.push(n),e}),[]);return Et(e)?i[0]:i}Qt.defaultProps=Nt,Qt.setDefaultProps=function(e){Object.keys(e).forEach((function(t){Nt[t]=e[t]}))},Qt.currentInput=_t,Object.assign({},ce,{effect:function(e){var t=e.state,n={popper:{position:t.options.strategy,left:"0",top:"0",margin:"0"},arrow:{position:"absolute"},reference:{}};Object.assign(t.elements.popper.style,n.popper),t.styles=n,t.elements.arrow&&Object.assign(t.elements.arrow.style,n.arrow)}}),Qt.setDefaultProps({render:Wt});var Kt='a,button,code,div,h1,h2,kbd,li,ol,p,span,strong,svg,ul{all:unset;box-sizing:border-box!important}div{display:block}:after,:before{all:unset}.tippy-box[data-animation=fade][data-state=hidden]{opacity:0}[data-tippy-root]{max-width:calc(100vw - 10px)}@media (forced-colors:active){[data-tippy-root]{border:2px solid transparent;border-radius:5px}}.tippy-box[data-placement^=top]>.tippy-arrow{bottom:0}.tippy-box[data-placement^=top]>.tippy-arrow:before{border-top-color:initial;border-width:8px 8px 0;bottom:-7px;left:0;transform-origin:center top}.tippy-box[data-placement^=bottom]>.tippy-arrow{top:0}.tippy-box[data-placement^=bottom]>.tippy-arrow:before{border-bottom-color:initial;border-width:0 8px 8px;left:0;top:-7px;transform-origin:center bottom}.tippy-box[data-placement^=left]>.tippy-arrow{right:0}.tippy-box[data-placement^=left]>.tippy-arrow:before{border-left-color:initial;border-width:8px 0 8px 8px;right:-7px;transform-origin:center left}.tippy-box[data-placement^=right]>.tippy-arrow{left:0}.tippy-box[data-placement^=right]>.tippy-arrow:before{border-right-color:initial;border-width:8px 8px 8px 0;left:-7px;transform-origin:center right}.tippy-arrow{color:#333;height:16px;width:16px}.tippy-arrow:before{border-color:transparent;border-style:solid;content:"";position:absolute}.tippy-content{padding:5px 9px;position:relative;z-index:1}.tippy-box[data-theme~=sa11y-theme][role=tooltip]{box-sizing:border-box!important}.tippy-box[data-theme~=sa11y-theme][role=tooltip][data-animation=fade][data-state=hidden]{opacity:0}.tippy-box[data-theme~=sa11y-theme][role=tooltip][data-inertia][data-state=visible]{transition-timing-function:cubic-bezier(.54,1.5,.38,1.11)}[role=dialog]{word-wrap:break-word;min-width:300px;text-align:start}[role=tooltip]{min-width:185px;text-align:center}.tippy-box[data-theme~=sa11y-theme]{-webkit-font-smoothing:auto;background-color:var(--sa11y-panel-bg);border-radius:4px;box-shadow:0 0 20px 4px rgba(154,161,177,.15),0 4px 80px -8px rgba(36,40,47,.25),0 4px 4px -2px rgba(91,94,105,.15)!important;color:var(--sa11y-panel-primary);display:block;font-family:var(--sa11y-font-face);font-size:var(--sa11y-normal-text);font-weight:400;letter-spacing:normal;line-height:22px;outline:0;padding:8px;position:relative;transition-property:transform,visibility,opacity}.tippy-box[data-theme~=sa11y-theme] code{font-family:monospace;font-size:calc(var(--sa11y-normal-text) - 1px)}.tippy-box[data-theme~=sa11y-theme] code,.tippy-box[data-theme~=sa11y-theme] kbd{-webkit-font-smoothing:auto;background-color:var(--sa11y-panel-badge);border-radius:3.2px;color:var(--sa11y-panel-primary);letter-spacing:normal;line-height:22px;padding:1.6px 4.8px}.tippy-box[data-theme~=sa11y-theme] .tippy-content{padding:5px 9px}.tippy-box[data-theme~=sa11y-theme] sub,.tippy-box[data-theme~=sa11y-theme] sup{font-size:var(--sa11y-small-text)}.tippy-box[data-theme~=sa11y-theme] ul{margin:0;margin-block-end:0;margin-block-start:0;padding:0;position:relative}.tippy-box[data-theme~=sa11y-theme] li{display:list-item;margin:5px 10px 0 20px;padding-bottom:5px}.tippy-box[data-theme~=sa11y-theme] a{color:var(--sa11y-hyperlink);cursor:pointer;text-decoration:underline}.tippy-box[data-theme~=sa11y-theme] a:focus,.tippy-box[data-theme~=sa11y-theme] a:hover{text-decoration:none}.tippy-box[data-theme~=sa11y-theme] strong{font-weight:600}.tippy-box[data-theme~=sa11y-theme] hr{background:var(--sa11y-panel-bg-splitter);border:none;height:1px;margin:10px 0;opacity:1;padding:0}.tippy-box[data-theme~=sa11y-theme] button.close-btn{margin:0}.tippy-box[data-theme~=sa11y-theme] button[data-sa11y-dismiss]{background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:5px;color:var(--sa11y-panel-primary);cursor:pointer;display:block;margin:10px 5px 5px 0;padding:4px 8px}.tippy-box[data-theme~=sa11y-theme] button[data-sa11y-dismiss]:focus,.tippy-box[data-theme~=sa11y-theme] button[data-sa11y-dismiss]:hover{background:var(--sa11y-shortcut-hover)}.tippy-box[data-theme~=sa11y-theme] .link-icon{background:var(--sa11y-panel-primary);display:inline-block;height:16px;margin-bottom:-3px;-webkit-mask:var(--sa11y-link-icon-svg) center no-repeat;mask:var(--sa11y-link-icon-svg) center no-repeat;width:16px}.tippy-box[data-theme~=sa11y-theme] .error .badge{background:var(--sa11y-error);color:var(--sa11y-error-text)}.tippy-box[data-theme~=sa11y-theme] .error .link-icon{background:var(--sa11y-error-text)}.tippy-box[data-theme~=sa11y-theme] .warning .badge{background:var(--sa11y-yellow-text);color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme] .warning .link-icon{background:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=top]>.tippy-arrow:before{border-top-color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=bottom]>.tippy-arrow:before{border-bottom-color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=left]>.tippy-arrow:before{border-left-color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=right]>.tippy-arrow:before{border-right-color:var(--sa11y-panel-bg)}@media (forced-colors:active){.tippy-box[data-theme~=sa11y-theme][data-placement^=bottom]>.tippy-arrow:before,.tippy-box[data-theme~=sa11y-theme][data-placement^=left]>.tippy-arrow:before,.tippy-box[data-theme~=sa11y-theme][data-placement^=right]>.tippy-arrow:before,.tippy-box[data-theme~=sa11y-theme][data-placement^=top]>.tippy-arrow:before{forced-color-adjust:none}.tippy-box[data-theme~=sa11y-theme] .tippy-arrow{z-index:-1}}.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus,.tippy-box[data-theme~=sa11y-theme] a:focus,.tippy-box[data-theme~=sa11y-theme] button:active,.tippy-box[data-theme~=sa11y-theme] button:focus{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus:not(:focus-visible),.tippy-box[data-theme~=sa11y-theme] a:focus:not(:focus-visible),.tippy-box[data-theme~=sa11y-theme] button:focus:not(:focus-visible){box-shadow:none;outline:0}.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus-visible,.tippy-box[data-theme~=sa11y-theme] a:focus-visible,.tippy-box[data-theme~=sa11y-theme] button:focus-visible{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}@media screen and (forced-colors:active){.tippy-box[data-theme~=sa11y-theme] .error-icon,.tippy-box[data-theme~=sa11y-theme] .hidden-icon,.tippy-box[data-theme~=sa11y-theme] .link-icon{filter:invert(1)}.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus,.tippy-box[data-theme~=sa11y-theme] a:focus,.tippy-box[data-theme~=sa11y-theme] button:focus{outline:3px solid transparent!important}}';class Yt extends HTMLElement{connectedCallback(){const e=this.attachShadow({mode:"open"}),o=document.createElement("style");o.innerHTML=Kt+O,e.appendChild(o);const i=[];w.Annotations.Array.forEach((e=>{const t=e.shadowRoot.querySelectorAll(".sa11y-btn");t&&i.push(...Array.from(t))}));const a=Qt(i,{interactive:!0,trigger:"mouseenter click",arrow:!0,offset:[0,8],delay:[0,400],theme:"sa11y-theme",placement:"auto-start",allowHTML:!0,role:"dialog",aria:{content:null,expanded:"auto"},appendTo:e,zIndex:2147483645,onShow(e){const t=e.popper;a.forEach((e=>{e!==t&&e.hide()}));e.reference.getRootNode().host.setAttribute("data-sa11y-opened","");const n=t.querySelector(".close-btn"),o=()=>{e.hide(),e.reference.focus()};n.addEventListener("click",o);const i=t=>{"Escape"===t.key&&(e.hide(),e.reference.focus())};t.addEventListener("keydown",i);const r=()=>{n.removeEventListener("click",o),t.removeEventListener("keydown",i),t.removeEventListener("hidden",r)};t.addEventListener("hidden",r)},onTrigger(e,t){"click"===t.type&&setTimeout((()=>{e.popper.querySelector(".close-btn").focus(),function(e){const t=e.querySelectorAll("a[href]:not([disabled]), button:not([disabled])"),n=t[0],o=t[t.length-1];e.addEventListener("keydown",(t=>{const i="Tab"===t.key||9===t.keyCode,a=e.getRootNode();i&&(t.shiftKey?a.activeElement===n&&(o.focus(),t.preventDefault()):a.activeElement===o&&(n.focus(),t.preventDefault()))}))}(e.popper)}),0)},onHide(e){e.popper.querySelector(".close-btn").removeEventListener("click",(()=>{e.hide()}));e.reference.getRootNode().host.removeAttribute("data-sa11y-opened")}});let r;r=-1!==navigator.userAgent.indexOf("Mac")?'<span class="kbd">Option</span> + <span class="kbd">S</span>':'<span class="kbd">Alt</span> + <span class="kbd">S</span>',Qt(n.Panel.skipButton,{content:`${t._("SHORTCUT_TOOLTIP")} &raquo; <br> ${r}`,allowHTML:!0,delay:[500,0],offset:[0,8],trigger:"mouseenter focusin",arrow:!0,placement:"top",theme:"sa11y-theme",maxWidth:165,role:"tooltip",aria:{content:null,expanded:!1},appendTo:e,zIndex:2147483645})}}class Xt extends HTMLElement{connectedCallback(){const e=this.attachShadow({mode:"open"}),t=document.createElement("style");t.innerHTML=Kt+O,e.appendChild(t),this.object=Qt(n.Panel.dismissButton,{delay:[500,0],offset:[0,8],trigger:"mouseenter focusin",arrow:!0,placement:"top",theme:"sa11y-theme",maxWidth:165,role:"tooltip",aria:{content:null,expanded:!1},appendTo:e,zIndex:2147483645})}}class Zt extends HTMLElement{connectedCallback(){const e=this.attachShadow({mode:"open"}),t=document.createElement("style");t.innerHTML='.instance{display:block;position:relative}.instance-inline{display:inline-block;position:relative;text-align:end}button{border-radius:50%;box-shadow:0 0 16px 0 rgba(0,0,0,.31);cursor:pointer;display:block;padding:0;transition:all .2s ease-in-out;z-index:8888}button,button:after{height:36px;position:absolute;width:36px}button:after{content:"";left:-7px;padding:7px;top:-7px}.warning-btn{margin:20px}.error-btn,.good-btn{margin:10px}.error-btn-text,.good-btn-text,.warning-btn-text{margin:-30px 10px}.error-btn,.error-btn-text{background:50% 50% var(--sa11y-error-svg) no-repeat;background-color:var(--sa11y-error);background-size:22px;border:1px solid var(--sa11y-error)}.error-btn-text:focus,.error-btn-text:hover,.error-btn:focus,.error-btn:hover{background-color:var(--sa11y-error-hover)}.good-btn,.good-btn-text{background:50% 50% var(--sa11y-good) var(--sa11y-good-svg) no-repeat;background-color:var(--sa11y-good);background-size:20px;border:1px solid var(--sa11y-good)}.good-btn-text:focus,.good-btn-text:hover,.good-btn:focus,.good-btn:hover{background-color:var(--sa11y-good-hover)}.warning-btn,.warning-btn-text{background:50% 50% var(--sa11y-warning) var(--sa11y-warning-svg) no-repeat;background-color:var(--sa11y-warning);background-size:24px;border:1px solid var(--sa11y-warning);transform:scaleX(var(--sa11y-icon-direction))}.warning-btn-text:focus,.warning-btn-text:hover,.warning-btn:focus,.warning-btn:hover{background-color:var(--sa11y-warning-hover)}.sa11y-btn:active,.sa11y-btn:focus{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}@media screen and (forced-colors:active){.sa11y-btn{border:1px solid transparent!important;forced-color-adjust:none;outline:3px solid transparent!important}}'+O,e.appendChild(t)}}const Jt=()=>{document.querySelectorAll("sa11y-annotation").forEach((e=>{const t=((e,t,n)=>{let o=e;for(;null!==o;){if(window.getComputedStyle(o).getPropertyValue(t)===n)return o;o=o.parentElement}return null})(e,"overflow","hidden");null!==t&&t.setAttribute("data-sa11y-overflow","")}))};class en extends HTMLElement{connectedCallback(){this.attachShadow({mode:"open"})}}class tn extends HTMLElement{connectedCallback(){const e=this.attachShadow({mode:"open"}),t=document.createElement("style");t.textContent="\n      span.heading-label {\n        background-color: #777678;\n        background-image: linear-gradient(to bottom right, #b629ce, #16aec2);\n        border-radius: 5px;\n        border: 1px solid #36a5c3;\n        color: white;\n        display: inline-block;\n        font-family: var(--sa11y-font-face);\n        font-weight: 500;\n        font-size: 17px;\n        line-height: normal;\n        letter-spacing: normal;\n        margin: -5px 0 0 5px;\n        padding: 3px;\n        position: absolute;\n        text-shadow: 1px 1px black;\n        -webkit-text-fill-color: white;\n        word-break: keep-all;\n        z-index: 200;\n      }\n      @media screen and (forced-colors: active) {\n        span.heading-label {\n          border: 2px solid transparent;\n        }\n      }",e.appendChild(t)}}const nn=(e,o)=>{if(0===e.offsetTop){const n=e.getRootNode().host,i=c(n,"display","none"),a=parseInt(n.getAttribute("data-sa11y-annotation"),10),r=x(o.find((e=>e.id===a)));(e=>{const t=c(e.getRootNode().host,"display","none");if(null!==t){g(t.previousElementSibling||t.parentNode)}})(e);const s=e.getAttribute("data-tippy-content");if(b(`${t._("NOT_VISIBLE_ALERT")}`,s,r),(()=>{const e=document.querySelector("sa11y-tooltips").shadowRoot.querySelector("button");null!==e&&e.click()})(),i){const e=i.previousElementSibling,{parentNode:t}=i;return e?p(e).top-150:p(t).top-150}}else f(),n.Panel.skipButton.focus();return p(e).top-150};let on=-1;const an=()=>{const e=u.getItem("sa11y-latest-dismissed");null!==e&&(on=parseInt(e,10)-1),u.removeItem("sa11y-latest-dismissed");const t=o("[data-sa11y-opened]","root");t[0]&&(on=parseInt(t[0].getAttribute("data-sa11y-position"),10))},rn=e=>{an();const t=w.Annotations.Array;on>=t.length-1&&(on=-1);const o=t[on+1].shadowRoot.querySelector("button"),i=nn(o,e);window.scrollTo({top:i,behavior:`${n.Global.scrollBehaviour}`}),0!==o.offsetTop&&(o.focus(),o.click()),on+=1},sn=e=>{if(an(),on>0){const t=w.Annotations.Array[on-1].shadowRoot.querySelector("button"),o=nn(t,e);window.scrollTo({top:o,behavior:`${n.Global.scrollBehaviour}`}),0!==t.offsetTop&&(t.focus(),t.click()),on-=1,-1===on&&(on=w.Annotations.Array.length-1)}};let ln,dn;function cn(e){ln=t=>{!function(e,t){w.Annotations.Array.length&&!n.Panel.skipButton.hasAttribute("disabled")&&(e.altKey&&"KeyS"===e.code?(e.preventDefault(),rn(t)):e.altKey&&"KeyW"===e.code&&(e.preventDefault(),sn(t)))}(t,e)},dn=()=>{rn(e)},document.addEventListener("keydown",ln),n.Panel.skipButton.addEventListener("click",dn)}const pn=(e,t)=>{const n=[];return n[0]=window.getComputedStyle(e,":before").getPropertyValue("content"),n[1]=window.getComputedStyle(e,":after").getPropertyValue("content"),n[0]="none"===n[0]?"":n[0].replace(/^"(.*)"$/,"$1"),n[1]="none"===n[1]?"":n[1].replace(/^"(.*)"$/,"$1"),` ${n[0]}${t}${n[1]}`},un=e=>{for(let t=0;t<1e3;t++){if(e.nextSibling())return e.previousNode();if(!e.parentNode())return!1}return!1},gn=(e,t=!1)=>{const n=e.getAttribute("aria-labelledby");if(!t&&n){const e=n.split(/\s+/);if(e.length>0){let t="";return e.forEach((e=>{const n=document.querySelector(`#${CSS.escape(e)}`);t+=n?`${mn(n,"",1)}`:""})),t}}const o=e.getAttribute("aria-label");return o&&o.trim().length>0?o:"noAria"},mn=(e,t,n=0)=>{const o=gn(e,n);if("noAria"!==o)return o;let i="";if(!e.children.length)return i=pn(e,e.textContent),!i.trim()&&e.hasAttribute("title")?e.getAttribute("title"):i;const a=(r=e,s=!0,l=!0,document.createTreeWalker(r,NodeFilter.SHOW_ALL,{acceptNode:e=>s&&e.nodeType===Node.ELEMENT_NODE||l&&e.nodeType===Node.TEXT_NODE?NodeFilter.FILTER_ACCEPT:NodeFilter.FILTER_REJECT}));var r,s,l;let d=!1,c=!1,p=0,u=!0;const g="noscript, style, script",m=e.querySelectorAll(t?`${t}, ${g}`:g);for(;a.nextNode()&&u;){p+=1;if(Array.from(m).some((e=>e.contains(a.currentNode))));else if(a.currentNode.nodeType===Node.TEXT_NODE)i+=` ${a.currentNode.nodeValue}`;else if(d&&!a.currentNode.closest("a"))c===i&&(i+=d),d=!1,c=!1;else if(!a.currentNode.hasAttribute("aria-hidden")||n&&p<3){const e=gn(a.currentNode,n);if("noAria"!==e)i+=` ${e}`,un(a)||(u=!1);else switch(a.currentNode.tagName){case"IMG":a.currentNode.hasAttribute("alt")&&(i+=a.currentNode.getAttribute("alt"));break;case"SVG":case"svg":"image"===a.currentNode.getAttribute("role")&&a.currentNode.hasAttribute("alt")&&(i+=pn(a.currentNode,a.currentNode.getAttribute("alt")),un(a)||(u=!1));break;case"A":a.currentNode.hasAttribute("title")?(d=a.currentNode.getAttribute("title"),c=i):(d=!1,c=!1),i+=pn(a.currentNode,"");break;default:i+=pn(a.currentNode,"")}}else un(a)||(u=!1)}d&&!c&&(i+=` ${d}`);return i=i.replace(/[\uE000-\uF8FF]/gu,""),!i.trim()&&e.hasAttribute("title")?e.getAttribute("title"):i};function fn(e,o){return w.Found.Images.forEach((i=>{const a="noAria"===gn(i)?i.getAttribute("alt"):gn(i),s=i.closest("a[href]"),c=s?d(s,n.Exclusions.LinkSpan).textContent:"",p=o.linkIgnoreStrings?c.replace(o.linkIgnoreStrings,""):c,u=s?l(p).length:0;if("true"!==i.getAttribute("aria-hidden"))if(s&&"true"===s.getAttribute("aria-hidden")){"-1"===s.getAttribute("tabindex")||e.push({element:i,type:"error",content:t.sprintf("LINK_HIDDEN_FOCUSABLE"),inline:!1,position:"beforebegin"})}else if(null===a)if(s){const n=0===u?t.sprintf("MISSING_ALT_LINK_MESSAGE"):t.sprintf("MISSING_ALT_LINK_BUT_HAS_TEXT_MESSAGE");e.push({element:i,type:"error",content:n,inline:!1,position:"beforebegin"})}else e.push({element:i,type:"error",content:t.sprintf("MISSING_ALT_MESSAGE"),inline:!1,position:"beforebegin"});else{const n=l(r(a)),d=(e=>{const n=[null,null,null];[".png",".jpg",".jpeg",".webp",".gif",".tiff",".svg","DSC_","IMG_","Photo_","Pic_","Pexels_","AdobeStock_","ScreenShot_","Picture_","Snap_","Capture_"].forEach((t=>{const o=t.toLowerCase();e.toLowerCase().indexOf(o)>=0&&(n[0]=t)})),(o.susAltStopWords?o.susAltStopWords.split(",").map((e=>e.trim())):t._("SUSPICIOUS_ALT_STOPWORDS")).forEach((t=>{const o=e.toLowerCase().indexOf(t);o>-1&&o<6&&(n[1]=t)})),t._("PLACEHOLDER_ALT_STOPWORDS").forEach((t=>{e.length===t.length&&e.toLowerCase().indexOf(t)>=0&&(n[2]=t)}));const{extraPlaceholderStopWords:i}=o;i.length&&i.split(",").map((e=>e.trim())).forEach((t=>{const o=e.toLowerCase().indexOf(t);o>-1&&o<6&&(n[2]=t)}));return n})(n),c=i.getAttribute("aria-label")||i.getAttribute("aria-labelledby"),p=""===a||" "===a,g=i.closest("figure"),f=g?.querySelector("figcaption"),b=f?f.textContent.trim():"",h=i.getAttribute("src")?i.getAttribute("src"):i.getAttribute("srcset");if(c&&""===n)return void e.push({element:i,type:"error",content:t.sprintf("MISSING_ALT_MESSAGE"),inline:!1,position:"beforebegin"});if(p){const n=m(`DECORATIVE${h}`);if(s){const n=0===u?"error":"good",o=0===u?t.sprintf("LINK_IMAGE_NO_ALT_TEXT"):t.sprintf("LINK_IMAGE_HAS_TEXT");e.push({element:i,type:n,content:o,inline:!1,position:"beforebegin"})}else if(g){const o=f&&b.length?t.sprintf("IMAGE_FIGURE_DECORATIVE"):t.sprintf("IMAGE_DECORATIVE");e.push({element:i,type:"warning",content:o,inline:!1,position:"beforebegin",dismiss:n})}else e.push({element:i,type:"warning",content:t.sprintf("IMAGE_DECORATIVE"),inline:!1,position:"beforebegin",dismiss:n});return}if(null!==d[0]){const o=s?t.sprintf("LINK_ALT_HAS_FILE_EXTENSION",d[0],n):t.sprintf("ALT_HAS_FILE_EXTENSION",d[0],n);e.push({element:i,type:"error",content:o,inline:!1,position:"beforebegin"})}else if(null!==d[2]){const o=s?t.sprintf("LINK_IMAGE_PLACEHOLDER_ALT_MESSAGE",n):t.sprintf("ALT_PLACEHOLDER_MESSAGE",n);e.push({element:i,type:"error",content:o,inline:!1,position:"beforebegin"})}else if(null!==d[1]){const o=m(`${h+n}`),a=s?t.sprintf("LINK_IMAGE_SUS_ALT_MESSAGE",d[1],n):t.sprintf("ALT_HAS_SUS_WORD",d[1],n);e.push({element:i,type:"warning",content:a,inline:!1,position:"beforebegin",dismiss:o})}else if(a.length>o.altTextMaxCharLength){const o=m(`${h+n+a.length}`),r=s?t.sprintf("LINK_IMAGE_LONG_ALT",a.length,n):t.sprintf("IMAGE_ALT_TOO_LONG",a.length,n);e.push({element:i,type:"warning",content:r,inline:!1,position:"beforebegin",dismiss:o})}else if(s){const o=m(`${h+n}`),a=r(l(mn(s))),d=0===u?t.sprintf("LINK_IMAGE_ALT_WARNING",n):t.sprintf("LINK_IMAGE_ALT_AND_TEXT_WARNING",n,a);e.push({element:i,type:"warning",content:d,inline:!1,position:"beforebegin",dismiss:o})}else if(g){if(!!f&&b.toLowerCase()===n.trim().toLowerCase()){const o=m(`FIGURE${h+n}`);e.push({element:i,type:"warning",content:t.sprintf("IMAGE_FIGURE_DUPLICATE_ALT",n),inline:!1,position:"beforebegin",dismiss:o})}else e.push({element:i,type:"good",content:t.sprintf("IMAGE_PASS",n),inline:!1,position:"beforebegin"})}else e.push({element:i,type:"good",content:t.sprintf("IMAGE_PASS",n),inline:!1,position:"beforebegin"})}})),e}function bn(e,o,i){let a;return w.Found.Headings.forEach(((s,d)=>{const p=mn(s,o.headerIgnoreSpan),u=r(l(o.headerIgnoreStrings?p.replace(o.headerIgnoreStrings,""):p)),g=n.Root.areaToCheck.contains(s),f=n.Root.areaToCheck.contains(s.getRootNode().host),b=g||f,h=parseInt(s.getAttribute("aria-level")||s.tagName.slice(1),10),y=u.length;let v=null,x=null;if(h-a>1&&0!==d)if(o.nonConsecutiveHeadingIsError)v=t.sprintf("HEADING_NON_CONSECUTIVE_LEVEL",a,h),e.push({element:s,type:"error",content:v,inline:!1,position:"beforebegin",isWithinRoot:b});else{x=t.sprintf("HEADING_NON_CONSECUTIVE_LEVEL",a,h);const n=m(`HEADING${h+u}`);e.push({element:s,type:"warning",content:x,inline:!1,position:"beforebegin",dismiss:n,isWithinRoot:b})}else if(0===y)if(s.querySelectorAll("img").length){const n=s.querySelector("img").getAttribute("alt");null!==n&&" "!==n&&""!==n||(v=t.sprintf("HEADING_EMPTY_WITH_IMAGE",h),e.push({element:s,type:"error",content:v,inline:!1,position:"beforebegin",isWithinRoot:b}))}else v=t.sprintf("HEADING_EMPTY",h),e.push({element:s,type:"error",content:v,inline:!1,position:"beforebegin",isWithinRoot:b});else if(0===d&&1!==h&&2!==h)v=t.sprintf("HEADING_FIRST"),e.push({element:s,type:"error",content:v,inline:!1,position:"beforebegin",isWithinRoot:b});else if(y>o.headingMaxCharLength&&o.flagLongHeadings){x=t.sprintf("HEADING_LONG",y);const n=m(`HEADING${h+u}`);e.push({element:s,type:"warning",content:x,inline:!1,position:"beforebegin",dismiss:n,isWithinRoot:b})}a=h;const w=!!((E=s).getAttribute("hidden")||0===E.offsetWidth&&0===E.offsetHeight||1===E.clientHeight&&1===E.clientWidth)||"none"===getComputedStyle(E).getPropertyValue("display");var E;const A=c(s,"display","none");if(null!==v)i.push({element:s,headingLevel:h,text:u,index:d,type:"error",hidden:w,visibleParent:A,isWithinRoot:b});else if(null!==x){const e=m(`HEADING${h+u}`);i.push({element:s,headingLevel:h,text:u,index:d,type:"warning",hidden:w,visibleParent:A,dismiss:e,isWithinRoot:b})}else null!==v&&null!==x||i.push({element:s,headingLevel:h,text:u,index:d,hidden:w,visibleParent:A,isWithinRoot:b})})),0===w.Found.HeadingOne.length&&o.missingH1&&e.push({type:"warning",content:t.sprintf("HEADING_MISSING_ONE"),dismiss:"missingH1"}),{results:e,headingOutline:i}}function hn(e,o){const i={};return w.Found.Links.forEach((a=>{const s=mn(a,n.Exclusions.LinkSpan),d=l(o.linkIgnoreStrings?s.replace(o.linkIgnoreStrings,""):s),c=(e=>{const n=[null,null,null,null];return t._("PARTIAL_ALT_STOPWORDS").forEach((t=>(e.length===t.length&&e.toLowerCase().indexOf(t)>=0&&(n[0]=t),!1))),(o.linkStopWords?o.linkStopWords.split(",").map((e=>e.trim())):t._("WARNING_ALT_STOPWORDS")).forEach((t=>(e.toLowerCase().indexOf(t)>=0&&(n[1]=t),!1))),["doiorg/","dlacmorg/","linkspringercom/","pubmedncbinlmnihgov/","scholargooglecom/","ieeexploreieeeorg/","researchgatenet/publication","sciencedirectcom/science/article"].forEach((t=>(e.toLowerCase().indexOf(t)>=0&&(n[2]=t),!1))),["http","edu/","com/","net/","org/","us/","ca/","de/","icu/","uk/","ru/","info/","top/","xyz/","tk/","cn/","ga/","cf/","nl/","io/","fr/","pe/","nz/","pt/","es/","pl/","ua/"].forEach((t=>(e.toLowerCase().indexOf(t)>=0&&(n[3]=t),!1))),n})(d.replace(/[^\w\s/]/g,"").replace(/\s+/g," ").trim()),p=1===d.length&&/[^a-zA-Z0-9]/g.test(d),g=d.match(/([<>↣↳←→↓«»↴]+)/),f=g?g[1]:null,b=a.getAttribute("href"),h="true"===a.getAttribute("aria-hidden"),y="-1"===a.getAttribute("tabindex"),v=a.querySelector(":scope [aria-labelledby], :scope [aria-label]")||a.getAttribute("aria-labelledby")||a.getAttribute("aria-label"),x=a.querySelector(":scope [aria-labelledby]")||a.getAttribute("aria-labelledby");if(a.querySelectorAll("img").length);else if(h)y||e.push({element:a,type:"error",content:t.sprintf("LINK_HIDDEN_FOCUSABLE"),inline:!0,position:"afterend"});else if(!b&&""!==b||0!==d.length)if(null!==c[0])e.push({element:a,type:"error",content:t.sprintf("LINK_STOPWORD",c[0]),inline:!0,position:"afterend"});else if(null!==c[1]||null!==f){const n=m(`LINK${d+b}`),o=f||c[1];e.push({element:a,type:"warning",content:t.sprintf("LINK_BEST_PRACTICES",o),inline:!0,position:"beforebegin",dismiss:n})}else if(null!==c[2]&&o.linksToDOI){const n=m(`LINK${d+c[2]+b}`);d.length>8&&e.push({element:a,type:"warning",content:t.sprintf("LINK_DOI"),inline:!0,position:"beforebegin",dismiss:n})}else if(null!==c[3]&&o.URLAsLinkTextWarning){const n=m(`LINK${d+c[2]+b}`);d.length>o.URLTextMaxCharLength&&e.push({element:a,type:"warning",content:t.sprintf("LINK_URL"),inline:!0,position:"beforebegin",dismiss:n})}else if(v){if(o.showGoodLinkButton){const n=r(d);e.push({element:a,type:"good",content:t.sprintf("LINK_LABEL",n),inline:!0,position:"afterend"})}}else p&&e.push({element:a,type:"error",content:t.sprintf("LINK_EMPTY"),inline:!0,position:"afterend"});else x?e.push({element:a,type:"error",content:t.sprintf("LINK_EMPTY_LABELLEDBY"),inline:!0,position:"afterend"}):a.children.length?e.push({element:a,type:"error",content:t.sprintf("LINK_EMPTY_LINK_NO_LABEL"),inline:!0,position:"afterend"}):e.push({element:a,type:"error",content:t.sprintf("LINK_EMPTY"),inline:!0,position:"afterend"});if(o.linksAdvancedPlugin){if("On"===u.getItem("sa11y-remember-links-advanced")||o.headless||o.checkAllHideToggles){const n=t._("NEW_WINDOW_PHRASES").some((e=>d.toLowerCase().includes(e))),o=["pdf","doc","docx","word","mp3","ppt","text","pptx","txt","exe","dmg","rtf","windows","macos","csv","xls","xlsx","mp4","mov","avi","zip"].concat(t._("FILE_TYPE_PHRASES")).some((e=>d.toLowerCase().includes(e))),s=a.matches("\n          a[href$='.pdf'],\n          a[href$='.doc'],\n          a[href$='.docx'],\n          a[href$='.zip'],\n          a[href$='.mp3'],\n          a[href$='.txt'],\n          a[href$='.exe'],\n          a[href$='.dmg'],\n          a[href$='.rtf'],\n          a[href$='.pptx'],\n          a[href$='.ppt'],\n          a[href$='.xls'],\n          a[href$='.xlsx'],\n          a[href$='.csv'],\n          a[href$='.mp4'],\n          a[href$='.mov'],\n          a[href$='.avi']\n        "),l=d.replace(/'|"|-|\.|\s+/g,"").toLowerCase();if(0!==l.length)if(i[l]&&!i[b]){const n=m(`LINK${l+b}`),o=r(d);e.push({element:a,type:"warning",content:t.sprintf("LINK_IDENTICAL_NAME",o),inline:!0,position:"beforebegin",dismiss:n})}else if("_blank"!==a.getAttribute("target")||s||n)if(s&&!o){const n=m(`LINK${l+b}`);e.push({element:a,type:"warning",content:t.sprintf("FILE_TYPE_WARNING"),inline:!0,position:"beforebegin",dismiss:n})}else i[l]=!0,i[b]=!0;else{const n=m(`LINK${l+b}`);e.push({element:a,type:"warning",content:t.sprintf("NEW_TAB_WARNING"),inline:!0,position:"beforebegin",dismiss:n})}}}})),e}const yn=e=>{if(e.startsWith("color(srgb")){const t=/srgb\s+([\d.]+)\s+([\d.]+)\s+([\d.]+)(?:\s+([\d.]+))?/,n=e.match(t);if(n&&n.length>=4){const[e,t,o,i]=n.slice(1),a=Math.min(1,parseFloat(e)),r=Math.min(1,parseFloat(t)),s=Math.min(1,parseFloat(o)),l=void 0!==i?Math.min(1,parseFloat(i)):1;return`rgba(${Math.round(255*a)}, ${Math.round(255*r)}, ${Math.round(255*s)}, ${l})`}return"invalid-format"}return e};class vn{constructor(c){const p={...e,...c};this.initialize=()=>{var e;(()=>{const{doNotRun:e}=p;return e.trim().length>0&&document.querySelector(e)})()||(customElements.define("sa11y-heading-label",tn),customElements.define("sa11y-heading-anchor",en),customElements.define("sa11y-annotation",Zt),customElements.define("sa11y-tooltips",Yt),customElements.define("sa11y-dismiss-tooltip",Xt),customElements.define("sa11y-control-panel",R),customElements.define("sa11y-console-error",N),n.initializeGlobal(p),n.initializeReadability(p),n.initializeExclusions(p),n.initializeEmbeddedContent(p),e=()=>{if(p.headless)this.checkAll(),u.removeItem("sa11y-dismissed");else{const i=new R;document.body.appendChild(i),function(e,o){n.Global.contrastPlugin?n.Panel.contrastToggle.onclick=async()=>{"On"===u.getItem("sa11y-remember-contrast")?(u.setItem("sa11y-remember-contrast","Off"),n.Panel.contrastToggle.textContent=`${t._("OFF")}`,n.Panel.contrastToggle.setAttribute("aria-pressed","false"),o(!1),await e()):(u.setItem("sa11y-remember-contrast","On"),n.Panel.contrastToggle.textContent=`${t._("ON")}`,n.Panel.contrastToggle.setAttribute("aria-pressed","true"),o(!1),await e())}:u.setItem("sa11y-remember-contrast","Off"),n.Global.formLabelsPlugin?n.Panel.labelsToggle.onclick=async()=>{"On"===u.getItem("sa11y-remember-labels")?(u.setItem("sa11y-remember-labels","Off"),n.Panel.labelsToggle.textContent=`${t._("OFF")}`,n.Panel.labelsToggle.setAttribute("aria-pressed","false"),o(!1),await e()):(u.setItem("sa11y-remember-labels","On"),n.Panel.labelsToggle.textContent=`${t._("ON")}`,n.Panel.labelsToggle.setAttribute("aria-pressed","true"),o(!1),await e())}:u.setItem("sa11y-remember-labels","Off"),n.Global.linksAdvancedPlugin?n.Panel.linksToggle.onclick=async()=>{"On"===u.getItem("sa11y-remember-links-advanced")?(u.setItem("sa11y-remember-links-advanced","Off"),n.Panel.linksToggle.textContent=`${t._("OFF")}`,n.Panel.linksToggle.setAttribute("aria-pressed","false"),o(!1),await e()):(u.setItem("sa11y-remember-links-advanced","On"),n.Panel.linksToggle.textContent=`${t._("ON")}`,n.Panel.linksToggle.setAttribute("aria-pressed","true"),o(!1),await e())}:u.setItem("sa11y-remember-links-advanced","Off"),n.Readability.Plugin&&(n.Panel.readabilityToggle.onclick=async()=>{"On"===u.getItem("sa11y-remember-readability")?(u.setItem("sa11y-remember-readability","Off"),n.Panel.readabilityToggle.textContent=`${t._("OFF")}`,n.Panel.readabilityToggle.setAttribute("aria-pressed","false"),n.Panel.readability.classList.remove("active"),o(!1),await e()):(u.setItem("sa11y-remember-readability","On"),n.Panel.readabilityToggle.textContent=`${t._("ON")}`,n.Panel.readabilityToggle.setAttribute("aria-pressed","true"),n.Panel.readability.classList.add("active"),o(!1),await e())},"On"===u.getItem("sa11y-remember-readability")&&n.Panel.readability.classList.add("active"));const i=window.matchMedia("(prefers-color-scheme: dark)");i.matches?(n.Panel.themeToggle.textContent=`${t._("ON")}`,n.Panel.themeToggle.setAttribute("aria-pressed","true")):(n.Panel.themeToggle.textContent=`${t._("OFF")}`,n.Panel.themeToggle.setAttribute("aria-pressed","false")),i.addEventListener("change",(()=>{i.matches?(n.Global.html.setAttribute("data-sa11y-theme","dark"),n.Panel.themeToggle.textContent=`${t._("ON")}`,n.Panel.themeToggle.setAttribute("aria-pressed","true"),u.setItem("sa11y-remember-theme","")):(n.Global.html.setAttribute("data-sa11y-theme","light"),n.Panel.themeToggle.textContent=`${t._("OFF")}`,n.Panel.themeToggle.setAttribute("aria-pressed","false"),u.setItem("sa11y-remember-theme",""))})),n.Panel.themeToggle.onclick=async()=>{const e=u.getItem("sa11y-remember-theme");"dark"===e?(n.Global.html.setAttribute("data-sa11y-theme","light"),u.setItem("sa11y-remember-theme","light"),n.Panel.themeToggle.textContent=`${t._("OFF")}`,n.Panel.themeToggle.setAttribute("aria-pressed","false")):"light"===e?(n.Global.html.setAttribute("data-sa11y-theme","dark"),u.setItem("sa11y-remember-theme","dark"),n.Panel.themeToggle.textContent=`${t._("ON")}`,n.Panel.themeToggle.setAttribute("aria-pressed","true")):i.matches?(n.Global.html.setAttribute("data-sa11y-theme","light"),u.setItem("sa11y-remember-theme","light"),n.Panel.themeToggle.textContent=`${t._("OFF")}`,n.Panel.themeToggle.setAttribute("aria-pressed","false")):(n.Global.html.setAttribute("data-sa11y-theme","dark"),u.setItem("sa11y-remember-theme","dark"),n.Panel.themeToggle.textContent=`${t._("ON")}`,n.Panel.themeToggle.setAttribute("aria-pressed","true"))};const a=u.getItem("sa11y-remember-theme");"dark"===a?(n.Global.html.setAttribute("data-sa11y-theme","dark"),u.setItem("sa11y-remember-theme","dark"),n.Panel.themeToggle.textContent=`${t._("ON")}`,n.Panel.themeToggle.setAttribute("aria-pressed","true")):"light"===a&&(n.Global.html.setAttribute("data-sa11y-theme","light"),u.setItem("sa11y-remember-theme","light"),n.Panel.themeToggle.textContent=`${t._("OFF")}`,n.Panel.themeToggle.setAttribute("aria-pressed","false")),n.Global.colourFilterPlugin&&n.Panel.colourFilterSelect.addEventListener("change",(async()=>{const i=parseInt(n.Panel.colourFilterSelect.value,10),a=["protanopia","deuteranopia","tritanopia","monochromacy"],r=[t._("RED_EYE"),t._("GREEN_EYE"),t._("BLUE_EYE"),t._("MONO_EYE")];i>=1&&i<=4?window.matchMedia("(forced-colors: active)").matches?b(t._("COLOUR_FILTER_HIGH_CONTRAST_MESSAGE")):(n.Root.areaToCheck.setAttribute("data-sa11y-filter",a[i-1]),n.Panel.colourFilterIcon.setAttribute("aria-label",r[i-1]),h(["data-sa11y-error","data-sa11y-warning","data-sa11y-good","data-sa11y-error-inline","data-sa11y-warning-inline","data-sa11y-overflow"],"document"),y(["sa11y-annotation","sa11y-tooltips","sa11y-heading-label"],"document"),n.Panel.skipButton.disabled=!0,n.Panel.pageIssues.classList.remove("active"),"left"!==n.Global.panelPosition&&"right"!==n.Global.panelPosition||n.Panel.settingsContent.classList.add("hide-settings-border"),n.Panel.colourFilterSelect.classList.add("active"),n.Panel.colourPanel.classList.add("active"),n.Panel.colourPanel.setAttribute("data-colour",a[i-1]),n.Panel.content.hidden=!0):(n.Root.areaToCheck.removeAttribute("data-sa11y-filter"),n.Panel.settingsContent.classList.remove("hide-settings-border"),n.Panel.colourFilterSelect.classList.remove("active"),n.Panel.colourPanel.classList.remove("active"),n.Panel.colourPanel.removeAttribute("data-colour"),n.Panel.content.hidden=!1,o(!1),await e())}))}(this.checkAll,this.resetAll),function(){n.Panel.outlineToggle.addEventListener("click",(()=>{"true"===n.Panel.outlineToggle.getAttribute("aria-expanded")?D():(M(),F(),B()),n.Panel.outlineHeader.focus()})),"Opened"===u.getItem("sa11y-remember-outline")&&M(),n.Global.showImageOutline&&(n.Panel.imagesToggle.addEventListener("click",(()=>{"true"===n.Panel.imagesToggle.getAttribute("aria-expanded")?B():(G(),D(),F()),n.Panel.imagesHeader.focus()})),"Opened"===u.getItem("sa11y-remember-images")&&G()),n.Panel.settingsToggle.addEventListener("click",(()=>{"true"===n.Panel.settingsToggle.getAttribute("aria-expanded")?F():(H(),D(),B()),n.Panel.settingsHeader.focus()})),"Opened"===u.getItem("sa11y-remember-settings")&&H(),n.Panel.skipToPageIssues.addEventListener("click",(()=>{n.Panel.pageIssuesHeader.focus()}));const e=n.Panel.panel.querySelectorAll("[role=tab]");let t=Array.from(e).findIndex((e=>e.classList.contains("active")));e.forEach((n=>{n.addEventListener("keydown",(n=>{"ArrowRight"===n.key?(n.preventDefault(),t=(t+1)%e.length,e[t].focus()):"ArrowLeft"===n.key&&(n.preventDefault(),t=(t-1+e.length)%e.length,e[t].focus())}))}))}(),function(){if(n.Global.colourFilterPlugin&&!1===n.Global.headless){const e=document.createElement("div");e.id="sa11y-colour-filters",e.setAttribute("aria-hidden","true"),e.innerHTML='\n        \x3c!-- DaltonLens SVG filters to simulate color vision deficiencies --\x3e\n        <svg id="sa11y-svg-filters" xmlns="http://www.w3.org/2000/svg">\n          <filter id="sa11y-protanopia" color-interpolation-filters="linearRGB">\n            <feColorMatrix type="matrix" in="SourceGraphic" values="\n                0.10889,0.89111,-0.00000,0,0\n                0.10889,0.89111,0.00000,0,0\n                0.00447,-0.00447,1.00000,0,0\n                0,0,0,1,0"\n            />\n          </filter>\n          <filter id="sa11y-deuteranopia" color-interpolation-filters="linearRGB">\n            <feColorMatrix type="matrix" in="SourceGraphic" values="\n                0.29031,0.70969,-0.00000,0,0\n                0.29031,0.70969,-0.00000,0,0\n                -0.02197,0.02197,1.00000,0,0\n                0,0,0,1,0"\n            />\n          </filter>\n          <filter id="sa11y-tritanopia" color-interpolation-filters="linearRGB">\n            <feColorMatrix type="matrix" in="SourceGraphic" result="ProjectionOnPlane1" values="\n                1.01354, 0.14268, -0.15622, 0, 0\n                -0.01181, 0.87561, 0.13619, 0, 0\n                0.07707, 0.81208, 0.11085, 0, 0\n                7.92482, -5.66475, -2.26007, 1, -0.2"\n            />\n            <feComponentTransfer in="ProjectionOnPlane1" result="ProjectionOnPlane1">\n                <feFuncA type="discrete" tableValues="0 0 0 0 1"/>\n            </feComponentTransfer>\n            <feColorMatrix type="matrix" in="SourceGraphic" result="ProjectionOnPlane2" values="\n                0.93337, 0.19999, -0.13336, 0, 0\n                0.05809, 0.82565, 0.11626, 0, 0\n                -0.37923, 1.13825, 0.24098, 0, 0\n                0,0,0,1,0"\n            />\n            <feBlend in="ProjectionOnPlane1" in2="ProjectionOnPlane2" mode="normal"/>\n          </filter>\n          <filter id="sa11y-monochromacy">\n            <feColorMatrix values="0.33 0.33 0.33 0 0                           0.33 0.33 0.33 0 0                           0.33 0.33 0.33 0 0                           0 0 0 1 0"></feColorMatrix>\n          </filter>\n        </svg>',document.body.appendChild(e)}}(),A(p.detectSPArouting,this.checkAll,this.resetAll),this.dismissTooltip=new Xt,document.body.appendChild(this.dismissTooltip),n.Panel.toggle.disabled=!1,setTimeout((()=>this.checkAll()),p.delayCheck),p.delayCheck>=700&&(n.Panel.toggle.disabled=!0),e=this.checkAll,o=this.resetAll,n.Panel.toggle.addEventListener("click",(t=>{"Opened"===u.getItem("sa11y-remember-panel")?(t.preventDefault(),u.setItem("sa11y-remember-panel","Closed"),n.Panel.toggle.classList.remove("on"),n.Panel.toggle.setAttribute("aria-expanded","false"),o(),0===n.Panel.notifCount.innerHTML.trim().length?n.Panel.notifBadge.style.display="none":n.Panel.notifBadge.style.display="flex"):(t.preventDefault(),u.setItem("sa11y-remember-panel","Opened"),n.Panel.toggle.classList.add("on"),n.Panel.toggle.setAttribute("aria-expanded","true"),e(),v(n.Panel.outlineList,n.Panel.outlineContent))})),"Opened"===u.getItem("sa11y-remember-panel")&&(n.Panel.toggle.classList.add("on"),n.Panel.toggle.setAttribute("aria-expanded","true"),n.Panel.panel.style.transform=""),document.onkeydown=e=>{const t=e||window.event;t.altKey&&"KeyA"===t.code&&(n.Panel.toggle.click(),n.Panel.toggle.focus())}}var e,o},"complete"===document.readyState?e():window.addEventListener("load",e))},this.checkAll=async(e=p.checkRoot,o=p.readabilityRoot)=>{try{this.results=[],this.headingOutline=[],this.imageOutline=[],this.errorCount=0,this.warningCount=0,this.customChecksRunning=!1;document.querySelector(e)||b(`${t.sprintf("ERROR_MISSING_ROOT_TARGET",e)}`),n.initializeRoot(e,o),function(e){if(e.autoDetectShadowComponents){const t="sa11y-heading-label, sa11y-heading-anchor, sa11y-annotation, sa11y-tooltips, sa11y-dismiss-tooltip, sa11y-control-panel, #sa11y-colour-filters, #sa11y-colour-filters *, script",n=document.querySelector(e.checkRoot);(n?Array.from(n.querySelectorAll(`*:not(${t})`)):Array.from(document.body.querySelectorAll(`*:not(${t})`))).forEach((e=>{e.shadowRoot&&"open"===e.shadowRoot.mode&&(e.setAttribute("data-sa11y-has-shadow-root",""),E(e))}))}else e.shadowComponents&&document.querySelectorAll(e.shadowComponents).forEach((e=>{e.setAttribute("data-sa11y-has-shadow-root",""),E(e)}))}(p),w.initializeElements(p),bn(this.results,p,this.headingOutline),hn(this.results,p),fn(this.results,p),function(e,n){if(n.contrastPlugin&&("On"===u.getItem("sa11y-remember-contrast")||n.headless||n.checkAllHideToggles)){let n={errors:[],warnings:[]};const o={parseRgb(e){let t,n,o,i,a;if(n=e.match(/rgb\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*\)/)){for(o=n.slice(1,4),t=i=0;i<=2;t=++i)o[t]=+o[t];o[3]=1}else if(n=e.match(/rgba\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*,\s*([01]|[01]?\.\d+)\)/))for(o=n.slice(1,5),t=a=0;a<=3;t=++a)o[t]=+o[t];return o},relativeLuminance(e){const t=[];for(let n=0;n<3;n++){const o=e[n]/255;t.push(o<.03928?o/12.92:Math.pow((o+.055)/1.055,2.4))}return.2126*t[0]+.7152*t[1]+.0722*t[2]},contrastRatio(e,t){const n=o.relativeLuminance(o.parseRgb(e)),i=o.relativeLuminance(o.parseRgb(t));return(Math.max(n,i)+.05)/(Math.min(n,i)+.05)},getBackground(e){if(11===e.nodeType){const t=e.getRootNode().host.parentNode;if(null===t)return"alpha";e=t}const t=getComputedStyle(e),n=yn(t.backgroundColor),i=t.backgroundImage,a=`${o.parseRgb(n)}`.split(",");return a[3]<1&&a[3]>0?"alpha":"rgba(0, 0, 0, 0)"!==n&&"transparent"!==n&&"none"===i&&"0"!==a[3]?n:"none"!==i?"image":"HTML"===e.tagName?"rgb(255, 255, 255)":o.getBackground(e.parentNode)},check(){n={errors:[],warnings:[]};for(let e=0;e<w.Found.Contrast.length;e++){const t=w.Found.Contrast[e];if(w.Found.Contrast){let e,i,a;const r=getComputedStyle(t),s=yn(r.color),{fill:l}=r,d=parseInt(r.fontSize,10)*(3/4),{fontWeight:c}=r,p=t.tagName,u=o.getBackground(t),g=[].reduce.call(t.childNodes,((e,t)=>e+(3===t.nodeType?t.textContent:"")),"").trim(),m=window.getComputedStyle(t),f=m.clip.replace(/\s/g,""),b=m.getPropertyValue("clip-path"),h=parseFloat(m.width),y=parseFloat(m.height);if(1===h&&1===y&&("inset(50%)"===b||/^(rect\(0(,\s*0){3}\)|rect\(1px(,\s*1px){3}\))$/.test(f)))return;if(s.startsWith("color("))a={elem:t},n.warnings.push(a);else if("SVG"===p)e=Math.round(100*o.contrastRatio(l,u))/100,e<3&&(i={elem:t,ratio:`${e}:1`},n.errors.push(i));else if(g.length||"INPUT"===p||"SELECT"===p||"TEXTAREA"===p){const r=t.getAttribute("type");"range"===r||"color"===r||("image"===u||"alpha"===u?(a={elem:t},n.warnings.push(a)):(e=Math.round(100*o.contrastRatio(s,u))/100,d>=18||d>=14&&c>=700?e<3&&(i={elem:t,ratio:`${e}:1`},n.errors.push(i)):e<4.5&&(i={elem:t,ratio:`${e}:1`},n.errors.push(i))))}}}return n}};o.check(),n.errors.forEach((n=>{const o=n.elem,i=n.ratio,a=r(d(o.cloneNode(!0),"script, style").textContent);"INPUT"===o.tagName?e.push({element:o,type:"error",content:t.sprintf("CONTRAST_INPUT_ERROR",i),inline:!1,position:"beforebegin"}):e.push({element:o,type:"error",content:t.sprintf("CONTRAST_ERROR",i,a),inline:!1,position:"beforebegin"})})),n.warnings.forEach((n=>{const o=n.elem,i=d(o.cloneNode(!0),"script, style").textContent,a=m(`CONTRAST${i}`),s=r(i);e.push({element:o,type:"warning",content:t.sprintf("CONTRAST_WARNING",s),inline:!1,position:"beforebegin",dismiss:a})}))}}(this.results,p),function(e,n){n.formLabelsPlugin&&("On"===u.getItem("sa11y-remember-labels")||n.headless||n.checkAllHideToggles)&&w.Found.Inputs.forEach((n=>{const o="true"===n.getAttribute("aria-hidden"),a="-1"===n.getAttribute("tabindex");if(i(n)||o&&a)return;const s=l(mn(n)),d=n.getAttribute("alt"),c=n.getAttribute("type"),p=n.getAttribute("title"),u=n.getAttribute("aria-label")||n.getAttribute("aria-labelledby");if("submit"===c||"button"===c||"hidden"===c)return;if("image"===c&&(!d||" "===d))return void(u||p||e.push({element:n,type:"error",content:t.sprintf("LABELS_MISSING_IMAGE_INPUT_MESSAGE"),inline:!1,position:"beforebegin"}));if("reset"===c){const o=m(`INPUT${s}`);return void e.push({element:n,type:"warning",content:t.sprintf("LABELS_INPUT_RESET_MESSAGE"),inline:!1,position:"beforebegin",dismiss:o})}if(u||p){if(0===s.length)e.push({element:n,type:"error",content:t.sprintf("LABELS_MISSING_LABEL_MESSAGE"),inline:!1,position:"beforebegin"});else{const o=m(`INPUT${s}`),i=r(s);e.push({element:n,type:"warning",content:t.sprintf("LABELS_ARIA_LABEL_INPUT_MESSAGE",i),inline:!1,position:"beforebegin",dismiss:o})}return}const g=n.closest("label"),f=g?l(mn(g)):"";if(g&&f.length)return;const b=n.getAttribute("id");b?w.Found.Labels.some((e=>e.getAttribute("for")===b))||e.push({element:n,type:"error",content:t.sprintf("LABELS_NO_FOR_ATTRIBUTE_MESSAGE",b),inline:!1,position:"beforebegin"}):e.push({element:n,type:"error",content:t.sprintf("LABELS_MISSING_LABEL_MESSAGE"),inline:!1,position:"beforebegin"})}))}(this.results,p),function(e,o){if(o.badLinksQA&&w.Found.CustomErrorLinks.forEach((n=>{e.push({element:n,type:"error",content:t.sprintf("QA_BAD_LINK",n),inline:!0,position:"beforebegin"})})),o.strongItalicsQA&&w.Found.StrongItalics.forEach((n=>{const o=n.textContent.trim().length,i=m(n.tagName+n.textContent);o>400&&e.push({element:n.parentNode,type:"warning",content:t.sprintf("QA_BAD_ITALICS"),inline:!1,position:"beforebegin",dismiss:i})})),w.Found.Links.forEach((i=>{if(i.hasAttribute("href")){const a=i.getAttribute("href"),r=i.matches(n.Global.documentLinks),s=i.matches('a[href$=".pdf"], a[href*=".pdf?"]'),l=m(`DOCUMENT${a}`),d="button"===i.getAttribute("role"),c=0!==i.textContent.trim().length;if(o.inPageLinkQA&&(a.startsWith("#")||""===a)&&!d&&c){const n=a.substring(1);document.getElementById(n)||document.getElementById(decodeURIComponent(n))||document.getElementById(encodeURIComponent(n))||e.push({element:i,type:"error",content:t.sprintf("QA_IN_PAGE_LINK"),inline:!0,position:"beforebegin"})}o.documentQA&&r?e.push({element:i,type:"warning",content:t.sprintf("QA_DOCUMENT"),inline:!0,position:"beforebegin",dismiss:l}):o.pdfQA&&s&&e.push({element:i,type:"warning",content:t.sprintf("QA_PDF"),inline:!0,position:"beforebegin",dismiss:l})}})),o.langQA&&(!w.Found.Language||w.Found.Language.length<2)&&e.push({type:"error",content:t.sprintf("QA_PAGE_LANGUAGE")}),o.blockquotesQA&&w.Found.Blockquotes.forEach((n=>{const o=n.textContent;if(o.trim().length<25){const i=r(o),a=m(`BLOCKQUOTE${i}`);e.push({element:n,type:"warning",content:t.sprintf("QA_BLOCKQUOTE_MESSAGE",i),inline:!1,position:"beforebegin",dismiss:a})}})),o.tablesQA&&w.Found.Tables.forEach((n=>{const i=n.querySelectorAll("th"),a=n.querySelectorAll("h1, h2, h3, h4, h5, h6");o.tablesQAmissingTH&&0===i.length&&e.push({element:n,type:"error",content:t.sprintf("TABLES_MISSING_HEADINGS"),inline:!1,position:"beforebegin"}),o.tablesQAsemanticHeadings&&a.length>0&&a.forEach((n=>{e.push({element:n,type:"error",content:t.sprintf("TABLES_SEMANTIC_HEADING"),inline:!1,position:"beforebegin"})})),i.forEach((i=>{if(o.tablesQAemptyTH&&0===i.textContent.trim().length){const a=o.tablesQAemptyTHisError?"error":"warning",r=m(`TABLE${n.textContent}`);e.push({element:i,type:a,content:t.sprintf("TABLES_EMPTY_HEADING"),inline:!1,position:"afterbegin",dismiss:r})}}))})),o.fakeHeadingsQA){const n='h1, h2, h3, h4, h5, h6, [role="heading"][aria-level], blockquote, table',o=o=>{const i=getComputedStyle(o).fontSize.replace("px",""),a=s(o),l=null===a.match(/[.;?!"]/),d=a.length>=4&&a.length<=120;if(i>=24&&!o.closest(n)&&d&&l){const n=r(a),i=m(`BOLD${n}`);e.push({element:o,type:"warning",content:t.sprintf("QA_FAKE_HEADING",n),inline:!1,position:"beforebegin",dismiss:i})}},i=o=>{if(/^(<strong>|<b>)/i.test(o.innerHTML.trim())&&!o.closest(n)){const n=o.querySelector("strong, b"),i=s(n),a=null===i.match(/[.:;?!"']/);if(i.length>=3&&i.length<=120&&a){const a=d(o,"strong, bold").textContent.trim().length;if(0!==a&&a<=250)return;const s=r(i),l=m(`BOLD${s}`);e.push({element:n,type:"warning",content:t.sprintf("QA_FAKE_HEADING",s),inline:!1,position:"beforebegin",dismiss:l})}}};w.Found.Paragraphs.forEach((e=>{o(e),i(e)}))}const i=new RegExp(/(([023456789][\d\s])|(1\d))/,""),a=new RegExp(/(^[aA1αаΑ]|[^\p{Alphabetic}\s])[-\s.)]/,"u"),l=new RegExp(/\p{Extended_Pictographic}/,"u"),c=["a","A","α","Α","а","А","1"],p=/[([{#]/,u={2:"1",b:"a",B:"A","β":"α","Β":"Α","б":"а","Б":"А"},g=e=>e.replace(/^b|^B|^б|^Б|^β|^В|^2/,(e=>u[e]));let f="",b="",h=!1;if(w.Found.Paragraphs.forEach(((n,o)=>{let r=!1,d=!1;b=b||s(n).replace("(","");const u=b.substring(0,2),y=u.match(a),v=u.match(i),x=u.match(l),E=p.test(u.charAt(0));if(u.length>0&&u!==f&&!v&&(y||x||E)){const i=w.Found.Paragraphs[o+1];if(i){if(r=s(i).replace("(","").substring(0,2),c.includes(r?.toLowerCase().trim()))return;const e=g(r);y?"A "!==u&&u===e&&(d=!0):x&&!h&&e.match(l)&&(d=!0,h=!0)}if(!d){let e=n?.querySelector("br")?.nextSibling?.nodeValue;e&&(e=e.replace(/<\/?[^>]+(>|$)/g,"").trim().substring(0,2),(p.test(e.charAt(0))||u===g(e)||!h&&e.match(l))&&(d=!0))}if(d){const o=m(`LIST${n.textContent}`);e.push({element:n,type:"warning",content:t.sprintf("QA_SHOULD_BE_LIST",u),inline:!1,position:"beforebegin",dismiss:o}),f=u}else f=""}b=r?"":r})),o.allCapsQA){const n=n=>{let o="";"LI"===n.tagName?n.childNodes.forEach((e=>{3===e.nodeType&&(o+=e.textContent)})):o=s(n);const i=o.match(/([A-Z]{2,}[ ])([A-Z]{2,}[ ])([A-Z]{2,}[ ])([A-Z]{2,})/g);if(i&&i[0].length>10){const i=m(`UPPERCASE${o}`);e.push({element:n,type:"warning",content:t.sprintf("QA_UPPERCASE_WARNING"),inline:!1,position:"beforebegin",dismiss:i})}};w.Found.Paragraphs.forEach((e=>n(e))),w.Found.Headings.forEach((e=>n(e))),w.Found.Lists.forEach((e=>n(e))),w.Found.Blockquotes.forEach((e=>n(e)))}o.duplicateIdQA&&document.querySelectorAll("body, [data-sa11y-has-shadow-root]").forEach((o=>{const i=new Set,a=(n,o)=>{n.forEach((n=>{const{id:a}=n;0!==a.trim().length&&(a&&!i.has(a)?i.add(a):Array.from(o.querySelectorAll(`\n                a[href*="${a}"],\n                label[for*="${a}"],\n                [aria-labelledby*="${a}"],\n                [aria-controls*="${a}"],\n                [aria-owns*="${a}"]`)).length>0&&e.push({element:n,type:"error",content:t.sprintf("QA_DUPLICATE_ID",a),inline:!0,position:"beforebegin"}))}))};o.shadowRoot&&a(Array.from(o.shadowRoot.querySelectorAll(`[id]:not(${n.Exclusions.Container})`)),o.shadowRoot),a(Array.from(o.querySelectorAll(`[id]:not(${n.Exclusions.Container})`)),o)}));if(o.underlinedTextQA){w.Found.Underlines.forEach((n=>{const o=m(`UNDERLINE${s(n)}`);e.push({element:n,type:"warning",content:t.sprintf("QA_TEXT_UNDERLINE_WARNING"),inline:!0,position:"beforebegin",dismiss:o})}));const n=n=>{const o=getComputedStyle(n).textDecorationLine,i=s(n);if("underline"===o){const o=m(`UNDERLINE${i}`);e.push({element:n,type:"warning",content:t.sprintf("QA_TEXT_UNDERLINE_WARNING"),inline:!1,position:"beforebegin",dismiss:o})}};w.Found.Paragraphs.forEach((e=>n(e))),w.Found.Headings.forEach((e=>n(e))),w.Found.Lists.forEach((e=>n(e))),w.Found.Blockquotes.forEach((e=>n(e))),w.Found.Spans.forEach((e=>n(e)))}if(o.pageTitleQA){const n=document.querySelector("head title");n&&0!==n.textContent.trim().length||e.push({type:"error",content:t.sprintf("QA_PAGE_TITLE")})}o.subscriptQA&&w.Found.Subscripts.forEach((n=>{const o=s(n);if(o.length>=80){const i=m(n.tagName+o);e.push({element:n,type:"warning",content:t.sprintf("QA_SUBSCRIPT_WARNING"),inline:!0,position:"beforebegin",dismiss:i})}}))}(this.results,p),function(e,n){n.embeddedContentAll&&(n.embeddedContentAudio&&w.Found.Audio.forEach((n=>{const o=m(`AUDIO${"undefined"!==n.getAttribute("src")?n.getAttribute("src"):n.querySelector("[src]")?.getAttribute("src")}`);e.push({element:n,type:"warning",content:t.sprintf("EMBED_AUDIO"),inline:!1,position:"beforebegin",dismiss:o})})),n.embeddedContentVideo&&w.Found.Videos.forEach((n=>{const o="undefined"!==n.getAttribute("src")?n.getAttribute("src"):n.querySelector("[src]")?.getAttribute("src"),i=n.querySelector("track"),a=i?.getAttribute("src");if(null===i||null===a||0===a.trim().length){const i=m(`VIDEO${o}`);e.push({element:n,type:"warning",content:t.sprintf("EMBED_VIDEO"),inline:!1,position:"beforebegin",dismiss:i})}})),n.embeddedContentDataViz&&w.Found.Visualizations.forEach((n=>{const o=m(`DATAVIZ${"undefined"!==n.getAttribute("src")?n.getAttribute("src"):n.querySelector("[src]")?.getAttribute("src")}`);e.push({element:n,type:"warning",content:t.sprintf("EMBED_DATA_VIZ"),inline:!1,position:"beforebegin",dismiss:o})})),n.embeddedContentTitles&&w.Found.iframes.forEach((n=>{const o=i(n),a="VIDEO"===n.tagName||"AUDIO"===n.tagName,r="true"===n.getAttribute("aria-hidden"),s="-1"===n.getAttribute("tabindex");if(o||a||r&&s)return;if(s)return void e.push({element:n,type:"error",content:t.sprintf("EMBED_UNFOCUSABLE"),inline:!1,position:"beforebegin"});const d=gn(n);0===l("noAria"===d?n.getAttribute("title")||"":d).length&&e.push({element:n,type:"error",content:t.sprintf("EMBED_MISSING_TITLE"),inline:!1,position:"beforebegin"})})),n.embeddedContentGeneral&&w.Found.EmbeddedContent.forEach((n=>{const o="true"===n.getAttribute("aria-hidden"),a="-1"===n.getAttribute("tabindex");if(i(n)||o&&a)return;if("VIDEO"===n.tagName||"AUDIO"===n.tagName)return;const r=m(`IFRAME${"undefined"!==n.getAttribute("src")?n.getAttribute("src"):n.querySelector("[src]")?.getAttribute("src")}`);e.push({element:n,type:"warning",content:t.sprintf("EMBED_GENERAL_WARNING"),inline:!1,position:"beforebegin",dismiss:r})})))}(this.results,p),function(){let e;if(n.Readability.Plugin&&"On"===u.getItem("sa11y-remember-readability")){w.Found.Readability.forEach((e=>{const t=e.textContent;t.length>=120&&"."!==t.charAt(t.length-1)&&e.insertAdjacentHTML("beforeend","<span data-sa11y-readability-period>.</span>")}));const o=[];for(let e=0;e<w.Found.Readability.length;e++){const t=s(d(w.Found.Readability[e]));""!==t&&o.push(t)}const i=o.join(" ").toString();if(["en","es","fr","de","nl","it","pt"].includes(n.Readability.Lang)){const o=e=>{let t=e;if(t=t.toLowerCase().replace(".","").replace("\n",""),t.length<=3)return 1;t=t.replace(/(?:[^laeiouy]es|ed|[^laeiouy]e)$/,""),t=t.replace(/^y/,"");const n=t.match(/[aeiouy]{1,2}/g);let o=0;return!!n&&(o=n.length),o},a=i.replace(/[.!?-]+/g," ").split(" ");let r=0;for(let e=0;e<a.length;e++)0!=a[e]&&(r+=1);const s=i.split(/[.!?]+/);let l=0;for(let e=0;e<s.length;e++)""!==s[e]&&(l+=1);let d=0,c=0,p=0;for(let e=0;e<a.length;e++)if(0!=a[e]){const t=o(a[e]);1===t&&(c+=1),2===t&&(p+=1),d+=t}let u=!1;"en"===n.Readability.Lang?u=206.835-r/l*1.015-d/r*84.6:"fr"===n.Readability.Lang?u=207-r/l*1.015-d/r*73.6:"es"===n.Readability.Lang?u=206.84-r/l*1.02-d/r*100*.6:"de"===n.Readability.Lang?u=180-r/l-d/r*58.5:"nl"===n.Readability.Lang?u=206.84-d/r*100*.77-r/l*.93:"it"===n.Readability.Lang?u=217-r/l*1.3-d/r*100*.6:"pt"===n.Readability.Lang&&(u=248.835-r/l*1.015-d/r*84.6),u>100?u=100:u<0&&(u=0);const g=u.toFixed(1),m=(r/l).toFixed(1),f=Math.round((r-(c+p))/r*100);let b;b=g>=0&&g<30?t._("LANG_VERY_DIFFICULT"):g>31&&g<49?t._("LANG_DIFFICULT"):g>50&&g<60?t._("LANG_FAIRLY_DIFFICULT"):t._("LANG_GOOD"),e={score:g,averageWordsPerSentence:m,complexWords:f,difficultyLevel:b,wordCount:r}}else if(["sv","fi","da","no","nb","nn"].includes(n.Readability.Lang)){const n=(e=>{const n=()=>e.replace(/[-'.]/gi,"").split(/[^a-zA-ZöäåÖÄÅÆæØø0-9]/g).filter(Boolean),o=n().length,i=n().filter((e=>e.length>6)).length,a=e.split(/\?|!|\.|\n/g).filter(Boolean).length,r=Math.round(o/a+100*i/o),s=(o/a).toFixed(1),l=Math.round(i/o*100);let d;return d=r>=0&&r<39?t._("LANG_GOOD"):r>40&&r<50?t._("LANG_FAIRLY_DIFFICULT"):r>51&&r<61?t._("LANG_DIFFICULT"):t._("LANG_VERY_DIFFICULT"),{score:r,difficulty:d,avgWordsPerSentence:s,complexWords:l,wordCount:o}})(i);e={score:n.score,averageWordsPerSentence:n.avgWordsPerSentence,complexWords:n.complexWords,difficultyLevel:n.difficulty,wordCount:n.wordCount}}!1===n.Global.headless&&(0===i.length?n.Panel.readabilityInfo.innerHTML=t._("READABILITY_NO_P_OR_LI_MESSAGE"):e.wordCount>30?(n.Panel.readabilityInfo.innerHTML=`${e.score} <span class="readability-score">${e.difficultyLevel}</span>`,n.Panel.readabilityDetails.innerHTML=`\n            <li>\n              <strong>${t._("LANG_AVG_SENTENCE")}</strong>\n              ${e.averageWordsPerSentence}\n            </li>\n            <li>\n              <strong>${t._("LANG_COMPLEX_WORDS")}</strong>\n              ${e.complexWords}%\n            </li>\n            <li>\n              <strong>${t._("LANG_TOTAL_WORDS")}</strong>\n              ${e.wordCount}\n            </li>`):n.Panel.readabilityInfo.textContent=t._("READABILITY_NOT_ENOUGH_CONTENT_MESSAGE"))}}(),this.imageResults=this.results.filter((e=>"IMG"===e.element?.tagName)),!0===p.customChecks?this.results:"object"==typeof p.customChecks?this.results.push(...p.customChecks):"listen"===p.customChecks&&(this.customChecksRunning=!0,this.customChecksFinished=0,document.addEventListener("sa11y-resume",(()=>{this.customChecksFinished+=1,1===this.customChecksFinished&&(this.customChecksRunning=!1,this.updateResults())})),window.setTimeout((()=>{if(!0===this.customChecksRunning)throw this.customChecksRunning=!1,this.updateResults(),Error("Sa11y: No custom checks were returned.")}),p.delayCustomCheck),window.setTimeout((()=>{const e=new CustomEvent("sa11y-custom-checks");document.dispatchEvent(e)}),0)),this.customChecksRunning||this.updateResults()}catch(e){const t=new N(e);throw document.body.appendChild(t),Error(e)}},this.updateResults=()=>{if(this.results=this.results.filter((e=>!1!==e.isWithinRoot)),this.results.forEach((e=>{const t=p.selectorPath?function(e){const t=[];let n=e;for(;n;){let e=n.localName;if(n.id){e+=`#${n.id}`,t.unshift(e);break}n.className&&(e+=`.${n.className.replace(/\s+/g,".")}`);const o=n.parentNode;if(!o)break;{const i=o.children;i.length>1&&(e+=`:nth-child(${Array.prototype.indexOf.call(i,n)+1})`),t.unshift(e)}n=n.parentNode.host||n.parentNode}return t.join(" > ")}(e.element):"",n=e.element?.outerHTML.replace(/\s{2,}/g," ").trim()||"";Object.assign(e,{htmlPath:n,cssPath:t})})),!1===p.headless){const l=function(e,o){let i=u.getItem("sa11y-dismissed");i=i?JSON.parse(i):[];const a=i.map((t=>{const n=e.find((e=>t.key.includes(e.dismiss)&&t.href===window.location.pathname));return void 0===n?"":n})),r=e.filter((e=>!a.find((t=>t.dismiss===e.dismiss)))),s=e.filter((e=>a.find((t=>t.dismiss===e.dismiss)))),l=s.length;return l>=1?(n.Panel.dismissButton.classList.add("active"),n.Panel.dismissTooltip.innerText=t.sprintf("PANEL_DISMISS_BUTTON",l),o.object.setContent(t.sprintf("PANEL_DISMISS_BUTTON",l))):n.Panel.dismissButton.classList.remove("active"),{dismissedIssues:i,updatedResults:r,dismissCount:l,dismissedResults:s}}(this.results,this.dismissTooltip,this.checkAll,this.resetAll);this.results=l.updatedResults,this.dismissed=l.dismissedIssues;const d=function(e,t,n){let o=t,i=n;return e.forEach(((t,n)=>{const a=e[n].type;"error"===a?o+=1:"warning"===a&&(i+=1)})),{error:o,warning:i}}(this.results,this.errorCount,this.warningCount);if(function(e,o){const i=e+o;0===i?(n.Panel.notifCount.innerText="",n.Panel.notifText.innerText="",n.Panel.notifBadge.style.display="none"):o>0&&0===e?(n.Panel.notifBadge.classList.add("notification-badge-warning"),n.Panel.notifCount.innerText=`${o}`,n.Panel.notifText.innerText=`${t._("PANEL_ICON_WARNINGS")}`):(n.Panel.notifBadge.classList.remove("notification-badge-warning"),n.Panel.notifCount.innerText=`${i}`,n.Panel.notifText.innerText=t._("PANEL_ICON_TOTAL")),"Opened"===u.getItem("sa11y-remember-panel")||0===i?n.Panel.notifBadge.style.display="none":n.Panel.notifBadge.style.display="flex"}(d.error,d.warning),"Opened"===u.getItem("sa11y-remember-panel")){this.results.forEach(((e,o)=>{Object.assign(e,{id:o}),function(e,o,i,r=!1,s,l,d,c){const p=["error","warning","good"];if(-1===p.indexOf(o))throw Error(`Invalid type [${o}] for annotation`);[o].forEach((t=>{if("error"===t&&void 0!==e){const t=r?"data-sa11y-error-inline":"data-sa11y-error";e.setAttribute(t,l)}else if("warning"===t&&void 0!==e){const t=r?"data-sa11y-warning-inline":"data-sa11y-warning";e.setAttribute(t,l)}}));const u={[p[0]]:t._("ERROR"),[p[1]]:t._("WARNING"),[p[2]]:t._("GOOD")},g=!0===c&&"warning"===o&&void 0!==d?`<button data-sa11y-dismiss='${l}' type='button'>${t._("DISMISS")}</button>`:"",m=document.createElement("sa11y-annotation");m.setAttribute("data-sa11y-annotation",l);const f=document.createElement("div"),b=document.createElement("li");void 0===e?(n.Panel.pageIssues.classList.add("active"),n.Panel.panel.classList.add("has-page-issues"),b.innerHTML=`<strong>${u[o]}</strong> ${i}${g}`,n.Panel.pageIssuesList.insertAdjacentElement("afterbegin",b)):(f.classList.add(r?"instance-inline":"instance"),f.innerHTML=`\n    <button\n      type="button"\n      aria-label="${u[o]}"\n      aria-haspopup="dialog"\n      class="sa11y-btn ${[o]}-btn${r?"-text":""}"\n      data-tippy-content=\n        "<div lang='${t._("LANG_CODE")}' class='${[o]}'>\n          <button type='button' class='close-btn close-tooltip' aria-label='${t._("ALERT_CLOSE")}'></button> <h2>${u[o]}</h2> ${a(i)} ${g}\n        </div>"\n    ></button>`,(e.closest("a, button")||e).insertAdjacentElement(s,m),m.shadowRoot.appendChild(f))}(e.element,e.type,e.content,e.inline,e.position,e.id,e.dismiss,p.dismissAnnotations)})),w.initializeAnnotations();const c=new Yt;document.body.appendChild(c),L(this.results,this.dismissed,this.checkAll,this.resetAll),U(this.dismissed,this.headingOutline,p),p.showImageOutline&&W(this.dismissed,this.imageResults),i=l.dismissCount,r=d.error,s=d.warning,n.Panel.skipButton.disabled=!1,n.Panel.panel.classList.add("active"),n.Global.html.setAttribute("data-sa11y-active","true"),n.Panel.skipButton.classList.add("active"),r>0&&s>0?(n.Panel.content.setAttribute("class","errors"),n.Panel.status.innerHTML=`${t._("ERRORS")} <span class="panel-count">${r}</span> ${t._("WARNINGS")} <span class="panel-count" id="warning-count">${s}</span>`):r>0?(n.Panel.content.setAttribute("class","errors"),n.Panel.status.innerHTML=`${t._("ERRORS")} <span class="panel-count">${r}</span>`):s>0?(n.Panel.content.setAttribute("class","warnings"),n.Panel.status.innerHTML=`${t._("WARNINGS")} <span class="panel-count" id="warning-count">${s}</span>`):i>0?(n.Panel.status.innerHTML=`${t._("DISMISSED")} <span class="panel-count">${i}</span>`,n.Panel.skipButton.classList.remove("active")):(n.Panel.content.setAttribute("class","good"),n.Panel.status.innerHTML=`${t._("PANEL_STATUS_NONE")}`),0===document.querySelectorAll("sa11y-annotation").length&&(n.Panel.skipButton.disabled=!0),cn(this.results),p.exportResultsPlugin&&(e=this.results,o=l.dismissedResults,n.Global.exportResultsPlugin&&(C=()=>{S(e,o)},$=()=>{P(e)},n.Panel.exportHTML.addEventListener("click",C),n.Panel.exportCSV.addEventListener("click",$))),v(n.Panel.pageIssuesList,n.Panel.pageIssuesContent),Jt(),document.querySelectorAll("sa11y-annotation").forEach((e=>{const t=e.nextElementSibling;null!==t&&"SA11Y-ANNOTATION"===t.tagName&&customElements.get("sa11y-annotation")&&t.shadowRoot.querySelector("button").setAttribute("style","margin: -5px -15px !important;")}))}n.Panel.toggle.disabled=!1}var e,o,i,r,s;const l=new CustomEvent("sa11y-check-complete",{detail:{results:this.results,page:window.location.pathname}});document.dispatchEvent(l)},this.resetAll=(e=!0)=>{for(n.Global.html.removeAttribute("data-sa11y-active"),y(["sa11y-annotation","sa11y-heading-label","sa11y-heading-anchor","sa11y-tooltips","[data-sa11y-readability-period]","[data-sa11y-clone-image-text]",".sa11y-css-utilities"],"document"),h(["data-sa11y-parent","data-sa11y-error","data-sa11y-warning","data-sa11y-good","data-sa11y-error-inline","data-sa11y-warning-inline","data-sa11y-overflow","data-sa11y-pulse-border","data-sa11y-filter","data-sa11y-has-shadow-root"],"document"),n.Panel.outlineList.innerHTML="",p.showImageOutline&&(n.Panel.imagesList.innerHTML=""),n.Panel.pageIssuesList.innerHTML="",n.Panel.readabilityInfo.innerHTML="",n.Panel.readabilityDetails.innerHTML="",n.Panel.panel.classList.remove("has-page-issues"),n.Panel.pageIssues.classList.remove("active"),f(),document.removeEventListener("keydown",ln),n.Panel.skipButton.removeEventListener("click",dn),n.Global.exportResultsPlugin&&(n.Panel.exportHTML.removeEventListener("click",C),n.Panel.exportCSV.removeEventListener("click",$)),n.Panel.panel?.removeEventListener("click",I),n.Panel.dismissButton?.removeEventListener("click",k),n.Global.colourFilterPlugin&&(n.Panel.colourFilterSelect.value=0,n.Panel.colourPanel.classList.remove("active"),n.Panel.colourFilterSelect.classList.remove("active"),n.Panel.content.hidden=!1);n.Panel.status.firstChild;)n.Panel.status.removeChild(n.Panel.status.firstChild);document.querySelectorAll("[data-sa11y-has-shadow-root]").forEach((e=>{e.removeAttribute("data-sa11y-has-shadow-root")})),e&&n.Panel.panel.classList.remove("active")},this.disabled=()=>{"Opened"===u.getItem("sa11y-remember-panel")&&n.Panel.toggle.click(),n.Panel.toggle.disabled=!0},this.enabled=()=>{n.Panel.toggle.disabled=!1},this.find=(e,t,n)=>o(e,t,n),this.prepareDismissal=e=>m(e),this.sanitizeHTML=e=>r(e),this.initialize()}}export{t as Lang,vn as Sa11y};
